package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BackupReferenceBuilder extends BackupReferenceFluent<BackupReferenceBuilder> implements VisitableBuilder<BackupReference,BackupReferenceBuilder>{
  public BackupReferenceBuilder() {
    this(new BackupReference());
  }
  
  public BackupReferenceBuilder(BackupReferenceFluent<?> fluent) {
    this(fluent, new BackupReference());
  }
  
  public BackupReferenceBuilder(BackupReferenceFluent<?> fluent,BackupReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BackupReferenceBuilder(BackupReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BackupReferenceFluent<?> fluent;
  
  public BackupReference build() {
    BackupReference buildable = new BackupReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}