package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ControlPlaneConfigSpecBuilder extends ControlPlaneConfigSpecFluent<ControlPlaneConfigSpecBuilder> implements VisitableBuilder<ControlPlaneConfigSpec,ControlPlaneConfigSpecBuilder>{
  public ControlPlaneConfigSpecBuilder() {
    this(new ControlPlaneConfigSpec());
  }
  
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpecFluent<?> fluent) {
    this(fluent, new ControlPlaneConfigSpec());
  }
  
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpecFluent<?> fluent,ControlPlaneConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ControlPlaneConfigSpecFluent<?> fluent;
  
  public ControlPlaneConfigSpec build() {
    ControlPlaneConfigSpec buildable = new ControlPlaneConfigSpec(fluent.getApiServerIPOverride(),fluent.getApiURLOverride(),fluent.buildServingCertificates());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}