package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPrivateLinkConfigBuilder extends AWSPrivateLinkConfigFluentImpl<AWSPrivateLinkConfigBuilder> implements VisitableBuilder<AWSPrivateLinkConfig,AWSPrivateLinkConfigBuilder>{
  public AWSPrivateLinkConfigBuilder() {
    this(false);
  }
  public AWSPrivateLinkConfigBuilder(Boolean validationEnabled) {
    this(new AWSPrivateLinkConfig(), validationEnabled);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSPrivateLinkConfig(), validationEnabled);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,AWSPrivateLinkConfig instance) {
    this(fluent, instance, false);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,AWSPrivateLinkConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAssociatedVPCs(instance.getAssociatedVPCs()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withDnsRecordType(instance.getDnsRecordType()); 
    fluent.withEndpointVPCInventory(instance.getEndpointVPCInventory()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance) {
    this(instance,false);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAssociatedVPCs(instance.getAssociatedVPCs()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withDnsRecordType(instance.getDnsRecordType()); 
    this.withEndpointVPCInventory(instance.getEndpointVPCInventory()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AWSPrivateLinkConfigFluent<?> fluent;
  Boolean validationEnabled;
  public AWSPrivateLinkConfig build() {
    AWSPrivateLinkConfig buildable = new AWSPrivateLinkConfig(fluent.getAssociatedVPCs(),fluent.getCredentialsSecretRef(),fluent.getDnsRecordType(),fluent.getEndpointVPCInventory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}