package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CheckpointBuilder extends CheckpointFluentImpl<CheckpointBuilder> implements VisitableBuilder<Checkpoint,CheckpointBuilder>{
  public CheckpointBuilder() {
    this(false);
  }
  public CheckpointBuilder(Boolean validationEnabled) {
    this(new Checkpoint(), validationEnabled);
  }
  public CheckpointBuilder(CheckpointFluent<?> fluent) {
    this(fluent, false);
  }
  public CheckpointBuilder(CheckpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Checkpoint(), validationEnabled);
  }
  public CheckpointBuilder(CheckpointFluent<?> fluent,Checkpoint instance) {
    this(fluent, instance, false);
  }
  public CheckpointBuilder(CheckpointFluent<?> fluent,Checkpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CheckpointBuilder(Checkpoint instance) {
    this(instance,false);
  }
  public CheckpointBuilder(Checkpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CheckpointFluent<?> fluent;
  Boolean validationEnabled;
  public Checkpoint build() {
    Checkpoint buildable = new Checkpoint(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}