package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterClaimSpecBuilder extends ClusterClaimSpecFluentImpl<ClusterClaimSpecBuilder> implements VisitableBuilder<ClusterClaimSpec,ClusterClaimSpecBuilder>{
  public ClusterClaimSpecBuilder() {
    this(false);
  }
  public ClusterClaimSpecBuilder(Boolean validationEnabled) {
    this(new ClusterClaimSpec(), validationEnabled);
  }
  public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterClaimSpec(), validationEnabled);
  }
  public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent,ClusterClaimSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent,ClusterClaimSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterPoolName(instance.getClusterPoolName()); 
    fluent.withLifetime(instance.getLifetime()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimSpecBuilder(ClusterClaimSpec instance) {
    this(instance,false);
  }
  public ClusterClaimSpecBuilder(ClusterClaimSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterPoolName(instance.getClusterPoolName()); 
    this.withLifetime(instance.getLifetime()); 
    this.withNamespace(instance.getNamespace()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterClaimSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterClaimSpec build() {
    ClusterClaimSpec buildable = new ClusterClaimSpec(fluent.getClusterPoolName(),fluent.getLifetime(),fluent.getNamespace(),fluent.getSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}