package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterInstallLocalReferenceBuilder extends ClusterInstallLocalReferenceFluentImpl<ClusterInstallLocalReferenceBuilder> implements VisitableBuilder<ClusterInstallLocalReference,ClusterInstallLocalReferenceBuilder>{
  public ClusterInstallLocalReferenceBuilder() {
    this(false);
  }
  public ClusterInstallLocalReferenceBuilder(Boolean validationEnabled) {
    this(new ClusterInstallLocalReference(), validationEnabled);
  }
  public ClusterInstallLocalReferenceBuilder(ClusterInstallLocalReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterInstallLocalReferenceBuilder(ClusterInstallLocalReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterInstallLocalReference(), validationEnabled);
  }
  public ClusterInstallLocalReferenceBuilder(ClusterInstallLocalReferenceFluent<?> fluent,ClusterInstallLocalReference instance) {
    this(fluent, instance, false);
  }
  public ClusterInstallLocalReferenceBuilder(ClusterInstallLocalReferenceFluent<?> fluent,ClusterInstallLocalReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterInstallLocalReferenceBuilder(ClusterInstallLocalReference instance) {
    this(instance,false);
  }
  public ClusterInstallLocalReferenceBuilder(ClusterInstallLocalReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterInstallLocalReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterInstallLocalReference build() {
    ClusterInstallLocalReference buildable = new ClusterInstallLocalReference(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}