package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolSpecBuilder extends ClusterPoolSpecFluentImpl<ClusterPoolSpecBuilder> implements VisitableBuilder<ClusterPoolSpec,ClusterPoolSpecBuilder>{
  public ClusterPoolSpecBuilder() {
    this(false);
  }
  public ClusterPoolSpecBuilder(Boolean validationEnabled) {
    this(new ClusterPoolSpec(), validationEnabled);
  }
  public ClusterPoolSpecBuilder(ClusterPoolSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolSpecBuilder(ClusterPoolSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPoolSpec(), validationEnabled);
  }
  public ClusterPoolSpecBuilder(ClusterPoolSpecFluent<?> fluent,ClusterPoolSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolSpecBuilder(ClusterPoolSpecFluent<?> fluent,ClusterPoolSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withBaseDomain(instance.getBaseDomain()); 
    fluent.withClaimLifetime(instance.getClaimLifetime()); 
    fluent.withHibernateAfter(instance.getHibernateAfter()); 
    fluent.withImageSetRef(instance.getImageSetRef()); 
    fluent.withInstallAttemptsLimit(instance.getInstallAttemptsLimit()); 
    fluent.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withMaxConcurrent(instance.getMaxConcurrent()); 
    fluent.withMaxSize(instance.getMaxSize()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withPullSecretRef(instance.getPullSecretRef()); 
    fluent.withRunningCount(instance.getRunningCount()); 
    fluent.withSize(instance.getSize()); 
    fluent.withSkipMachinePools(instance.getSkipMachinePools()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolSpecBuilder(ClusterPoolSpec instance) {
    this(instance,false);
  }
  public ClusterPoolSpecBuilder(ClusterPoolSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withClaimLifetime(instance.getClaimLifetime()); 
    this.withHibernateAfter(instance.getHibernateAfter()); 
    this.withImageSetRef(instance.getImageSetRef()); 
    this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit()); 
    this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef()); 
    this.withLabels(instance.getLabels()); 
    this.withMaxConcurrent(instance.getMaxConcurrent()); 
    this.withMaxSize(instance.getMaxSize()); 
    this.withPlatform(instance.getPlatform()); 
    this.withPullSecretRef(instance.getPullSecretRef()); 
    this.withRunningCount(instance.getRunningCount()); 
    this.withSize(instance.getSize()); 
    this.withSkipMachinePools(instance.getSkipMachinePools()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPoolSpec build() {
    ClusterPoolSpec buildable = new ClusterPoolSpec(fluent.getAnnotations(),fluent.getBaseDomain(),fluent.getClaimLifetime(),fluent.getHibernateAfter(),fluent.getImageSetRef(),fluent.getInstallAttemptsLimit(),fluent.getInstallConfigSecretTemplateRef(),fluent.getLabels(),fluent.getMaxConcurrent(),fluent.getMaxSize(),fluent.getPlatform(),fluent.getPullSecretRef(),fluent.getRunningCount(),fluent.getSize(),fluent.getSkipMachinePools());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}