package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterStateStatusBuilder extends ClusterStateStatusFluentImpl<ClusterStateStatusBuilder> implements VisitableBuilder<ClusterStateStatus,ClusterStateStatusBuilder>{
  public ClusterStateStatusBuilder() {
    this(false);
  }
  public ClusterStateStatusBuilder(Boolean validationEnabled) {
    this(new ClusterStateStatus(), validationEnabled);
  }
  public ClusterStateStatusBuilder(ClusterStateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterStateStatusBuilder(ClusterStateStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterStateStatus(), validationEnabled);
  }
  public ClusterStateStatusBuilder(ClusterStateStatusFluent<?> fluent,ClusterStateStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterStateStatusBuilder(ClusterStateStatusFluent<?> fluent,ClusterStateStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterOperators(instance.getClusterOperators()); 
    fluent.withLastUpdated(instance.getLastUpdated()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterStateStatusBuilder(ClusterStateStatus instance) {
    this(instance,false);
  }
  public ClusterStateStatusBuilder(ClusterStateStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterOperators(instance.getClusterOperators()); 
    this.withLastUpdated(instance.getLastUpdated()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterStateStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterStateStatus build() {
    ClusterStateStatus buildable = new ClusterStateStatus(fluent.getClusterOperators(),fluent.getLastUpdated());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}