package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGatesEnabledBuilder extends FeatureGatesEnabledFluentImpl<FeatureGatesEnabledBuilder> implements VisitableBuilder<FeatureGatesEnabled,FeatureGatesEnabledBuilder>{
  public FeatureGatesEnabledBuilder() {
    this(false);
  }
  public FeatureGatesEnabledBuilder(Boolean validationEnabled) {
    this(new FeatureGatesEnabled(), validationEnabled);
  }
  public FeatureGatesEnabledBuilder(FeatureGatesEnabledFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGatesEnabledBuilder(FeatureGatesEnabledFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGatesEnabled(), validationEnabled);
  }
  public FeatureGatesEnabledBuilder(FeatureGatesEnabledFluent<?> fluent,FeatureGatesEnabled instance) {
    this(fluent, instance, false);
  }
  public FeatureGatesEnabledBuilder(FeatureGatesEnabledFluent<?> fluent,FeatureGatesEnabled instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FeatureGatesEnabledBuilder(FeatureGatesEnabled instance) {
    this(instance,false);
  }
  public FeatureGatesEnabledBuilder(FeatureGatesEnabled instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnabled(instance.getEnabled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FeatureGatesEnabledFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGatesEnabled build() {
    FeatureGatesEnabled buildable = new FeatureGatesEnabled(fluent.getEnabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}