package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OvirtClusterDeprovisionBuilder extends OvirtClusterDeprovisionFluentImpl<OvirtClusterDeprovisionBuilder> implements VisitableBuilder<OvirtClusterDeprovision,OvirtClusterDeprovisionBuilder>{
  public OvirtClusterDeprovisionBuilder() {
    this(false);
  }
  public OvirtClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new OvirtClusterDeprovision(), validationEnabled);
  }
  public OvirtClusterDeprovisionBuilder(OvirtClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public OvirtClusterDeprovisionBuilder(OvirtClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OvirtClusterDeprovision(), validationEnabled);
  }
  public OvirtClusterDeprovisionBuilder(OvirtClusterDeprovisionFluent<?> fluent,OvirtClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public OvirtClusterDeprovisionBuilder(OvirtClusterDeprovisionFluent<?> fluent,OvirtClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    fluent.withClusterID(instance.getClusterID()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OvirtClusterDeprovisionBuilder(OvirtClusterDeprovision instance) {
    this(instance,false);
  }
  public OvirtClusterDeprovisionBuilder(OvirtClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    this.withClusterID(instance.getClusterID()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OvirtClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public OvirtClusterDeprovision build() {
    OvirtClusterDeprovision buildable = new OvirtClusterDeprovision(fluent.getCertificatesSecretRef(),fluent.getClusterID(),fluent.getCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}