package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncIdentityProviderListBuilder extends SyncIdentityProviderListFluentImpl<SyncIdentityProviderListBuilder> implements VisitableBuilder<SyncIdentityProviderList,SyncIdentityProviderListBuilder>{
  public SyncIdentityProviderListBuilder() {
    this(false);
  }
  public SyncIdentityProviderListBuilder(Boolean validationEnabled) {
    this(new SyncIdentityProviderList(), validationEnabled);
  }
  public SyncIdentityProviderListBuilder(SyncIdentityProviderListFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncIdentityProviderListBuilder(SyncIdentityProviderListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncIdentityProviderList(), validationEnabled);
  }
  public SyncIdentityProviderListBuilder(SyncIdentityProviderListFluent<?> fluent,SyncIdentityProviderList instance) {
    this(fluent, instance, false);
  }
  public SyncIdentityProviderListBuilder(SyncIdentityProviderListFluent<?> fluent,SyncIdentityProviderList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SyncIdentityProviderListBuilder(SyncIdentityProviderList instance) {
    this(instance,false);
  }
  public SyncIdentityProviderListBuilder(SyncIdentityProviderList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SyncIdentityProviderListFluent<?> fluent;
  Boolean validationEnabled;
  public SyncIdentityProviderList build() {
    SyncIdentityProviderList buildable = new SyncIdentityProviderList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}