package io.fabric8.openshift.api.model.hive.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    fluent.withCluster(instance.getCluster()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withDatacenter(instance.getDatacenter()); 
    fluent.withDefaultDatastore(instance.getDefaultDatastore()); 
    fluent.withFolder(instance.getFolder()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withVCenter(instance.getVCenter()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    this.withCluster(instance.getCluster()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withDatacenter(instance.getDatacenter()); 
    this.withDefaultDatastore(instance.getDefaultDatastore()); 
    this.withFolder(instance.getFolder()); 
    this.withNetwork(instance.getNetwork()); 
    this.withVCenter(instance.getVCenter()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getCertificatesSecretRef(),fluent.getCluster(),fluent.getCredentialsSecretRef(),fluent.getDatacenter(),fluent.getDefaultDatastore(),fluent.getFolder(),fluent.getNetwork(),fluent.getVCenter());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}