package io.fabric8.openshift.api.model.hive.agent.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalPlatformBuilder extends BareMetalPlatformFluentImpl<BareMetalPlatformBuilder> implements VisitableBuilder<BareMetalPlatform,BareMetalPlatformBuilder>{
  public BareMetalPlatformBuilder() {
    this(false);
  }
  public BareMetalPlatformBuilder(Boolean validationEnabled) {
    this(new BareMetalPlatform(), validationEnabled);
  }
  public BareMetalPlatformBuilder(BareMetalPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalPlatformBuilder(BareMetalPlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BareMetalPlatform(), validationEnabled);
  }
  public BareMetalPlatformBuilder(BareMetalPlatformFluent<?> fluent,BareMetalPlatform instance) {
    this(fluent, instance, false);
  }
  public BareMetalPlatformBuilder(BareMetalPlatformFluent<?> fluent,BareMetalPlatform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAgentSelector(instance.getAgentSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BareMetalPlatformBuilder(BareMetalPlatform instance) {
    this(instance,false);
  }
  public BareMetalPlatformBuilder(BareMetalPlatform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAgentSelector(instance.getAgentSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BareMetalPlatformFluent<?> fluent;
  Boolean validationEnabled;
  public BareMetalPlatform build() {
    BareMetalPlatform buildable = new BareMetalPlatform(fluent.getAgentSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}