package io.fabric8.openshift.api.model.hive.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EncryptionKeyReferenceFluentImpl<A extends EncryptionKeyReferenceFluent<A>> extends BaseFluent<A> implements EncryptionKeyReferenceFluent<A>{
  public EncryptionKeyReferenceFluentImpl() {
  }
  public EncryptionKeyReferenceFluentImpl(EncryptionKeyReference instance) {
    if (instance != null) {
      this.withKmsKey(instance.getKmsKey());
      this.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private KMSKeyReferenceBuilder kmsKey;
  private String kmsKeyServiceAccount;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildKmsKey instead.
   * @return The buildable object.
   */
  @Deprecated
  public KMSKeyReference getKmsKey() {
    return this.kmsKey!=null ?this.kmsKey.build():null;
  }
  public KMSKeyReference buildKmsKey() {
    return this.kmsKey!=null ?this.kmsKey.build():null;
  }
  public A withKmsKey(KMSKeyReference kmsKey) {
    _visitables.get("kmsKey").remove(this.kmsKey);
    if (kmsKey!=null){ this.kmsKey= new KMSKeyReferenceBuilder(kmsKey); _visitables.get("kmsKey").add(this.kmsKey);} else { this.kmsKey = null; _visitables.get("kmsKey").remove(this.kmsKey); } return (A) this;
  }
  public Boolean hasKmsKey() {
    return this.kmsKey != null;
  }
  public A withNewKmsKey(String keyRing,String location,String name,String projectID) {
    return (A)withKmsKey(new KMSKeyReference(keyRing, location, name, projectID));
  }
  public EncryptionKeyReferenceFluentImpl.KmsKeyNested<A> withNewKmsKey() {
    return new EncryptionKeyReferenceFluentImpl.KmsKeyNestedImpl();
  }
  public EncryptionKeyReferenceFluentImpl.KmsKeyNested<A> withNewKmsKeyLike(KMSKeyReference item) {
    return new EncryptionKeyReferenceFluentImpl.KmsKeyNestedImpl(item);
  }
  public EncryptionKeyReferenceFluentImpl.KmsKeyNested<A> editKmsKey() {
    return withNewKmsKeyLike(getKmsKey());
  }
  public EncryptionKeyReferenceFluentImpl.KmsKeyNested<A> editOrNewKmsKey() {
    return withNewKmsKeyLike(getKmsKey() != null ? getKmsKey(): new KMSKeyReferenceBuilder().build());
  }
  public EncryptionKeyReferenceFluentImpl.KmsKeyNested<A> editOrNewKmsKeyLike(KMSKeyReference item) {
    return withNewKmsKeyLike(getKmsKey() != null ? getKmsKey(): item);
  }
  public String getKmsKeyServiceAccount() {
    return this.kmsKeyServiceAccount;
  }
  public A withKmsKeyServiceAccount(String kmsKeyServiceAccount) {
    this.kmsKeyServiceAccount=kmsKeyServiceAccount; return (A) this;
  }
  public Boolean hasKmsKeyServiceAccount() {
    return this.kmsKeyServiceAccount != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EncryptionKeyReferenceFluentImpl that = (EncryptionKeyReferenceFluentImpl) o;
    if (!java.util.Objects.equals(kmsKey, that.kmsKey)) return false;

    if (!java.util.Objects.equals(kmsKeyServiceAccount, that.kmsKeyServiceAccount)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(kmsKey,  kmsKeyServiceAccount,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kmsKey != null) { sb.append("kmsKey:"); sb.append(kmsKey + ","); }
    if (kmsKeyServiceAccount != null) { sb.append("kmsKeyServiceAccount:"); sb.append(kmsKeyServiceAccount + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class KmsKeyNestedImpl<N> extends KMSKeyReferenceFluentImpl<EncryptionKeyReferenceFluentImpl.KmsKeyNested<N>> implements EncryptionKeyReferenceFluentImpl.KmsKeyNested<N>,Nested<N>{
    KmsKeyNestedImpl(KMSKeyReference item) {
      this.builder = new KMSKeyReferenceBuilder(this, item);
    }
    KmsKeyNestedImpl() {
      this.builder = new KMSKeyReferenceBuilder(this);
    }
    KMSKeyReferenceBuilder builder;
    public N and() {
      return (N) EncryptionKeyReferenceFluentImpl.this.withKmsKey(builder.build());
    }
    public N endKmsKey() {
      return and();
    }
    
  }
  
}