package io.fabric8.openshift.api.model.hive.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withOvirtClusterId(instance.getOvirtClusterId());
      fluent.withOvirtNetworkName(instance.getOvirtNetworkName());
      fluent.withStorageDomainId(instance.getStorageDomainId());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withStorageDomainId(instance.getStorageDomainId());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getCertificatesSecretRef(),fluent.getCredentialsSecretRef(),fluent.getOvirtClusterId(),fluent.getOvirtNetworkName(),fluent.getStorageDomainId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}