package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSAssociatedVPCBuilder extends AWSAssociatedVPCFluentImpl<AWSAssociatedVPCBuilder> implements VisitableBuilder<AWSAssociatedVPC,AWSAssociatedVPCBuilder>{
  public AWSAssociatedVPCBuilder() {
    this(false);
  }
  public AWSAssociatedVPCBuilder(Boolean validationEnabled) {
    this(new AWSAssociatedVPC(), validationEnabled);
  }
  public AWSAssociatedVPCBuilder(AWSAssociatedVPCFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSAssociatedVPCBuilder(AWSAssociatedVPCFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSAssociatedVPC(), validationEnabled);
  }
  public AWSAssociatedVPCBuilder(AWSAssociatedVPCFluent<?> fluent,AWSAssociatedVPC instance) {
    this(fluent, instance, false);
  }
  public AWSAssociatedVPCBuilder(AWSAssociatedVPCFluent<?> fluent,AWSAssociatedVPC instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withRegion(instance.getRegion());
      fluent.withVpcID(instance.getVpcID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSAssociatedVPCBuilder(AWSAssociatedVPC instance) {
    this(instance,false);
  }
  public AWSAssociatedVPCBuilder(AWSAssociatedVPC instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withVpcID(instance.getVpcID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSAssociatedVPCFluent<?> fluent;
  Boolean validationEnabled;
  public AWSAssociatedVPC build() {
    AWSAssociatedVPC buildable = new AWSAssociatedVPC(fluent.getCredentialsSecretRef(),fluent.getRegion(),fluent.getVpcID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}