package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSDNSZoneSpecBuilder extends AWSDNSZoneSpecFluentImpl<AWSDNSZoneSpecBuilder> implements VisitableBuilder<AWSDNSZoneSpec,AWSDNSZoneSpecBuilder>{
  public AWSDNSZoneSpecBuilder() {
    this(false);
  }
  public AWSDNSZoneSpecBuilder(Boolean validationEnabled) {
    this(new AWSDNSZoneSpec(), validationEnabled);
  }
  public AWSDNSZoneSpecBuilder(AWSDNSZoneSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSDNSZoneSpecBuilder(AWSDNSZoneSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSDNSZoneSpec(), validationEnabled);
  }
  public AWSDNSZoneSpecBuilder(AWSDNSZoneSpecFluent<?> fluent,AWSDNSZoneSpec instance) {
    this(fluent, instance, false);
  }
  public AWSDNSZoneSpecBuilder(AWSDNSZoneSpecFluent<?> fluent,AWSDNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalTags(instance.getAdditionalTags());
      fluent.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withRegion(instance.getRegion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSDNSZoneSpecBuilder(AWSDNSZoneSpec instance) {
    this(instance,false);
  }
  public AWSDNSZoneSpecBuilder(AWSDNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalTags(instance.getAdditionalTags());
      this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSDNSZoneSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AWSDNSZoneSpec build() {
    AWSDNSZoneSpec buildable = new AWSDNSZoneSpec(fluent.getAdditionalTags(),fluent.getCredentialsAssumeRole(),fluent.getCredentialsSecretRef(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}