package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureClusterDeprovisionBuilder extends AzureClusterDeprovisionFluentImpl<AzureClusterDeprovisionBuilder> implements VisitableBuilder<AzureClusterDeprovision,AzureClusterDeprovisionBuilder>{
  public AzureClusterDeprovisionBuilder() {
    this(false);
  }
  public AzureClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new AzureClusterDeprovision(), validationEnabled);
  }
  public AzureClusterDeprovisionBuilder(AzureClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureClusterDeprovisionBuilder(AzureClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureClusterDeprovision(), validationEnabled);
  }
  public AzureClusterDeprovisionBuilder(AzureClusterDeprovisionFluent<?> fluent,AzureClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public AzureClusterDeprovisionBuilder(AzureClusterDeprovisionFluent<?> fluent,AzureClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCloudName(instance.getCloudName());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureClusterDeprovisionBuilder(AzureClusterDeprovision instance) {
    this(instance,false);
  }
  public AzureClusterDeprovisionBuilder(AzureClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCloudName(instance.getCloudName());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public AzureClusterDeprovision build() {
    AzureClusterDeprovision buildable = new AzureClusterDeprovision(fluent.getCloudName(),fluent.getCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}