package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CheckpointListBuilder extends CheckpointListFluentImpl<CheckpointListBuilder> implements VisitableBuilder<CheckpointList,CheckpointListBuilder>{
  public CheckpointListBuilder() {
    this(false);
  }
  public CheckpointListBuilder(Boolean validationEnabled) {
    this(new CheckpointList(), validationEnabled);
  }
  public CheckpointListBuilder(CheckpointListFluent<?> fluent) {
    this(fluent, false);
  }
  public CheckpointListBuilder(CheckpointListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CheckpointList(), validationEnabled);
  }
  public CheckpointListBuilder(CheckpointListFluent<?> fluent,CheckpointList instance) {
    this(fluent, instance, false);
  }
  public CheckpointListBuilder(CheckpointListFluent<?> fluent,CheckpointList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CheckpointListBuilder(CheckpointList instance) {
    this(instance,false);
  }
  public CheckpointListBuilder(CheckpointList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CheckpointListFluent<?> fluent;
  Boolean validationEnabled;
  public CheckpointList build() {
    CheckpointList buildable = new CheckpointList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}