package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterClaimConditionBuilder extends ClusterClaimConditionFluentImpl<ClusterClaimConditionBuilder> implements VisitableBuilder<ClusterClaimCondition,ClusterClaimConditionBuilder>{
  public ClusterClaimConditionBuilder() {
    this(false);
  }
  public ClusterClaimConditionBuilder(Boolean validationEnabled) {
    this(new ClusterClaimCondition(), validationEnabled);
  }
  public ClusterClaimConditionBuilder(ClusterClaimConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimConditionBuilder(ClusterClaimConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterClaimCondition(), validationEnabled);
  }
  public ClusterClaimConditionBuilder(ClusterClaimConditionFluent<?> fluent,ClusterClaimCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimConditionBuilder(ClusterClaimConditionFluent<?> fluent,ClusterClaimCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimConditionBuilder(ClusterClaimCondition instance) {
    this(instance,false);
  }
  public ClusterClaimConditionBuilder(ClusterClaimCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterClaimConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterClaimCondition build() {
    ClusterClaimCondition buildable = new ClusterClaimCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}