package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterClaimListBuilder extends ClusterClaimListFluentImpl<ClusterClaimListBuilder> implements VisitableBuilder<ClusterClaimList,ClusterClaimListBuilder>{
  public ClusterClaimListBuilder() {
    this(false);
  }
  public ClusterClaimListBuilder(Boolean validationEnabled) {
    this(new ClusterClaimList(), validationEnabled);
  }
  public ClusterClaimListBuilder(ClusterClaimListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimListBuilder(ClusterClaimListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterClaimList(), validationEnabled);
  }
  public ClusterClaimListBuilder(ClusterClaimListFluent<?> fluent,ClusterClaimList instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimListBuilder(ClusterClaimListFluent<?> fluent,ClusterClaimList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimListBuilder(ClusterClaimList instance) {
    this(instance,false);
  }
  public ClusterClaimListBuilder(ClusterClaimList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterClaimListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterClaimList build() {
    ClusterClaimList buildable = new ClusterClaimList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}