package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeploymentConditionBuilder extends ClusterDeploymentConditionFluentImpl<ClusterDeploymentConditionBuilder> implements VisitableBuilder<ClusterDeploymentCondition,ClusterDeploymentConditionBuilder>{
  public ClusterDeploymentConditionBuilder() {
    this(false);
  }
  public ClusterDeploymentConditionBuilder(Boolean validationEnabled) {
    this(new ClusterDeploymentCondition(), validationEnabled);
  }
  public ClusterDeploymentConditionBuilder(ClusterDeploymentConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeploymentConditionBuilder(ClusterDeploymentConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeploymentCondition(), validationEnabled);
  }
  public ClusterDeploymentConditionBuilder(ClusterDeploymentConditionFluent<?> fluent,ClusterDeploymentCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterDeploymentConditionBuilder(ClusterDeploymentConditionFluent<?> fluent,ClusterDeploymentCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeploymentConditionBuilder(ClusterDeploymentCondition instance) {
    this(instance,false);
  }
  public ClusterDeploymentConditionBuilder(ClusterDeploymentCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDeploymentConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeploymentCondition build() {
    ClusterDeploymentCondition buildable = new ClusterDeploymentCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}