package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterDeploymentStatusFluentImpl<A extends ClusterDeploymentStatusFluent<A>> extends BaseFluent<A> implements ClusterDeploymentStatusFluent<A>{
  public ClusterDeploymentStatusFluentImpl() {
  }
  public ClusterDeploymentStatusFluentImpl(ClusterDeploymentStatus instance) {
    if (instance != null) {
      this.withApiURL(instance.getApiURL());
      this.withCertificateBundles(instance.getCertificateBundles());
      this.withCliImage(instance.getCliImage());
      this.withConditions(instance.getConditions());
      this.withInstallRestarts(instance.getInstallRestarts());
      this.withInstallStartedTimestamp(instance.getInstallStartedTimestamp());
      this.withInstallVersion(instance.getInstallVersion());
      this.withInstalledTimestamp(instance.getInstalledTimestamp());
      this.withInstallerImage(instance.getInstallerImage());
      this.withPlatformStatus(instance.getPlatformStatus());
      this.withPowerState(instance.getPowerState());
      this.withProvisionRef(instance.getProvisionRef());
      this.withWebConsoleURL(instance.getWebConsoleURL());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiURL;
  private ArrayList<CertificateBundleStatusBuilder> certificateBundles = new ArrayList<CertificateBundleStatusBuilder>();
  private String cliImage;
  private ArrayList<ClusterDeploymentConditionBuilder> conditions = new ArrayList<ClusterDeploymentConditionBuilder>();
  private Integer installRestarts;
  private String installStartedTimestamp;
  private String installVersion;
  private String installedTimestamp;
  private String installerImage;
  private PlatformStatusBuilder platformStatus;
  private String powerState;
  private LocalObjectReferenceBuilder provisionRef;
  private String webConsoleURL;
  private Map<String,Object> additionalProperties;
  public String getApiURL() {
    return this.apiURL;
  }
  public A withApiURL(String apiURL) {
    this.apiURL=apiURL; return (A) this;
  }
  public Boolean hasApiURL() {
    return this.apiURL != null;
  }
  public A addToCertificateBundles(int index,CertificateBundleStatus item) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleStatusBuilder>();}
    CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
    if (index < 0 || index >= certificateBundles.size()) { _visitables.get("certificateBundles").add(builder); certificateBundles.add(builder); } else { _visitables.get("certificateBundles").add(index, builder); certificateBundles.add(index, builder);}
    return (A)this;
  }
  public A setToCertificateBundles(int index,CertificateBundleStatus item) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleStatusBuilder>();}
    CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
    if (index < 0 || index >= certificateBundles.size()) { _visitables.get("certificateBundles").add(builder); certificateBundles.add(builder); } else { _visitables.get("certificateBundles").set(index, builder); certificateBundles.set(index, builder);}
    return (A)this;
  }
  public A addToCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus... items) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleStatusBuilder>();}
    for (CertificateBundleStatus item : items) {CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);_visitables.get("certificateBundles").add(builder);this.certificateBundles.add(builder);} return (A)this;
  }
  public A addAllToCertificateBundles(Collection<CertificateBundleStatus> items) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleStatusBuilder>();}
    for (CertificateBundleStatus item : items) {CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);_visitables.get("certificateBundles").add(builder);this.certificateBundles.add(builder);} return (A)this;
  }
  public A removeFromCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus... items) {
    for (CertificateBundleStatus item : items) {CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);_visitables.get("certificateBundles").remove(builder);if (this.certificateBundles != null) {this.certificateBundles.remove(builder);}} return (A)this;
  }
  public A removeAllFromCertificateBundles(Collection<CertificateBundleStatus> items) {
    for (CertificateBundleStatus item : items) {CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);_visitables.get("certificateBundles").remove(builder);if (this.certificateBundles != null) {this.certificateBundles.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCertificateBundles(Predicate<CertificateBundleStatusBuilder> predicate) {
    if (certificateBundles == null) return (A) this;
    final Iterator<CertificateBundleStatusBuilder> each = certificateBundles.iterator();
    final List visitables = _visitables.get("certificateBundles");
    while (each.hasNext()) {
      CertificateBundleStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCertificateBundles instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateBundleStatus> getCertificateBundles() {
    return certificateBundles != null ? build(certificateBundles) : null;
  }
  public List<CertificateBundleStatus> buildCertificateBundles() {
    return certificateBundles != null ? build(certificateBundles) : null;
  }
  public CertificateBundleStatus buildCertificateBundle(int index) {
    return this.certificateBundles.get(index).build();
  }
  public CertificateBundleStatus buildFirstCertificateBundle() {
    return this.certificateBundles.get(0).build();
  }
  public CertificateBundleStatus buildLastCertificateBundle() {
    return this.certificateBundles.get(certificateBundles.size() - 1).build();
  }
  public CertificateBundleStatus buildMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate) {
    for (CertificateBundleStatusBuilder item: certificateBundles) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate) {
    for (CertificateBundleStatusBuilder item: certificateBundles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCertificateBundles(List<CertificateBundleStatus> certificateBundles) {
    if (this.certificateBundles != null) { _visitables.get("certificateBundles").clear();}
    if (certificateBundles != null) {this.certificateBundles = new ArrayList(); for (CertificateBundleStatus item : certificateBundles){this.addToCertificateBundles(item);}} else { this.certificateBundles = null;} return (A) this;
  }
  public A withCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus... certificateBundles) {
    if (this.certificateBundles != null) {this.certificateBundles.clear(); _visitables.remove("certificateBundles"); }
    if (certificateBundles != null) {for (CertificateBundleStatus item :certificateBundles){ this.addToCertificateBundles(item);}} return (A) this;
  }
  public Boolean hasCertificateBundles() {
    return certificateBundles != null && !certificateBundles.isEmpty();
  }
  public A addNewCertificateBundle(Boolean generated,String name) {
    return (A)addToCertificateBundles(new CertificateBundleStatus(generated, name));
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> addNewCertificateBundle() {
    return new ClusterDeploymentStatusFluentImpl.CertificateBundlesNestedImpl();
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> addNewCertificateBundleLike(CertificateBundleStatus item) {
    return new ClusterDeploymentStatusFluentImpl.CertificateBundlesNestedImpl(-1, item);
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> setNewCertificateBundleLike(int index,CertificateBundleStatus item) {
    return new ClusterDeploymentStatusFluentImpl.CertificateBundlesNestedImpl(index, item);
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> editCertificateBundle(int index) {
    if (certificateBundles.size() <= index) throw new RuntimeException("Can't edit certificateBundles. Index exceeds size.");
    return setNewCertificateBundleLike(index, buildCertificateBundle(index));
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> editFirstCertificateBundle() {
    if (certificateBundles.size() == 0) throw new RuntimeException("Can't edit first certificateBundles. The list is empty.");
    return setNewCertificateBundleLike(0, buildCertificateBundle(0));
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> editLastCertificateBundle() {
    int index = certificateBundles.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last certificateBundles. The list is empty.");
    return setNewCertificateBundleLike(index, buildCertificateBundle(index));
  }
  public ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<A> editMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<certificateBundles.size();i++) { 
    if (predicate.test(certificateBundles.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching certificateBundles. No match found.");
    return setNewCertificateBundleLike(index, buildCertificateBundle(index));
  }
  public String getCliImage() {
    return this.cliImage;
  }
  public A withCliImage(String cliImage) {
    this.cliImage=cliImage; return (A) this;
  }
  public Boolean hasCliImage() {
    return this.cliImage != null;
  }
  public A addToConditions(int index,ClusterDeploymentCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterDeploymentConditionBuilder>();}
    ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ClusterDeploymentCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterDeploymentConditionBuilder>();}
    ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterDeploymentConditionBuilder>();}
    for (ClusterDeploymentCondition item : items) {ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterDeploymentCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterDeploymentConditionBuilder>();}
    for (ClusterDeploymentCondition item : items) {ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition... items) {
    for (ClusterDeploymentCondition item : items) {ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterDeploymentCondition> items) {
    for (ClusterDeploymentCondition item : items) {ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ClusterDeploymentConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterDeploymentConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterDeploymentConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterDeploymentCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ClusterDeploymentCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ClusterDeploymentCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ClusterDeploymentCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ClusterDeploymentCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ClusterDeploymentCondition buildMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate) {
    for (ClusterDeploymentConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate) {
    for (ClusterDeploymentConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterDeploymentCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterDeploymentCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ClusterDeploymentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ClusterDeploymentStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ClusterDeploymentCondition item) {
    return new ClusterDeploymentStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ClusterDeploymentCondition item) {
    return new ClusterDeploymentStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterDeploymentStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Integer getInstallRestarts() {
    return this.installRestarts;
  }
  public A withInstallRestarts(Integer installRestarts) {
    this.installRestarts=installRestarts; return (A) this;
  }
  public Boolean hasInstallRestarts() {
    return this.installRestarts != null;
  }
  public String getInstallStartedTimestamp() {
    return this.installStartedTimestamp;
  }
  public A withInstallStartedTimestamp(String installStartedTimestamp) {
    this.installStartedTimestamp=installStartedTimestamp; return (A) this;
  }
  public Boolean hasInstallStartedTimestamp() {
    return this.installStartedTimestamp != null;
  }
  public String getInstallVersion() {
    return this.installVersion;
  }
  public A withInstallVersion(String installVersion) {
    this.installVersion=installVersion; return (A) this;
  }
  public Boolean hasInstallVersion() {
    return this.installVersion != null;
  }
  public String getInstalledTimestamp() {
    return this.installedTimestamp;
  }
  public A withInstalledTimestamp(String installedTimestamp) {
    this.installedTimestamp=installedTimestamp; return (A) this;
  }
  public Boolean hasInstalledTimestamp() {
    return this.installedTimestamp != null;
  }
  public String getInstallerImage() {
    return this.installerImage;
  }
  public A withInstallerImage(String installerImage) {
    this.installerImage=installerImage; return (A) this;
  }
  public Boolean hasInstallerImage() {
    return this.installerImage != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPlatformStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlatformStatus getPlatformStatus() {
    return this.platformStatus!=null ?this.platformStatus.build():null;
  }
  public PlatformStatus buildPlatformStatus() {
    return this.platformStatus!=null ?this.platformStatus.build():null;
  }
  public A withPlatformStatus(PlatformStatus platformStatus) {
    _visitables.get("platformStatus").remove(this.platformStatus);
    if (platformStatus!=null){ this.platformStatus= new PlatformStatusBuilder(platformStatus); _visitables.get("platformStatus").add(this.platformStatus);} else { this.platformStatus = null; _visitables.get("platformStatus").remove(this.platformStatus); } return (A) this;
  }
  public Boolean hasPlatformStatus() {
    return this.platformStatus != null;
  }
  public ClusterDeploymentStatusFluentImpl.PlatformStatusNested<A> withNewPlatformStatus() {
    return new ClusterDeploymentStatusFluentImpl.PlatformStatusNestedImpl();
  }
  public ClusterDeploymentStatusFluentImpl.PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
    return new ClusterDeploymentStatusFluentImpl.PlatformStatusNestedImpl(item);
  }
  public ClusterDeploymentStatusFluentImpl.PlatformStatusNested<A> editPlatformStatus() {
    return withNewPlatformStatusLike(getPlatformStatus());
  }
  public ClusterDeploymentStatusFluentImpl.PlatformStatusNested<A> editOrNewPlatformStatus() {
    return withNewPlatformStatusLike(getPlatformStatus() != null ? getPlatformStatus(): new PlatformStatusBuilder().build());
  }
  public ClusterDeploymentStatusFluentImpl.PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
    return withNewPlatformStatusLike(getPlatformStatus() != null ? getPlatformStatus(): item);
  }
  public String getPowerState() {
    return this.powerState;
  }
  public A withPowerState(String powerState) {
    this.powerState=powerState; return (A) this;
  }
  public Boolean hasPowerState() {
    return this.powerState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProvisionRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getProvisionRef() {
    return this.provisionRef!=null ?this.provisionRef.build():null;
  }
  public LocalObjectReference buildProvisionRef() {
    return this.provisionRef!=null ?this.provisionRef.build():null;
  }
  public A withProvisionRef(LocalObjectReference provisionRef) {
    _visitables.get("provisionRef").remove(this.provisionRef);
    if (provisionRef!=null){ this.provisionRef= new LocalObjectReferenceBuilder(provisionRef); _visitables.get("provisionRef").add(this.provisionRef);} else { this.provisionRef = null; _visitables.get("provisionRef").remove(this.provisionRef); } return (A) this;
  }
  public Boolean hasProvisionRef() {
    return this.provisionRef != null;
  }
  public A withNewProvisionRef(String name) {
    return (A)withProvisionRef(new LocalObjectReference(name));
  }
  public ClusterDeploymentStatusFluentImpl.ProvisionRefNested<A> withNewProvisionRef() {
    return new ClusterDeploymentStatusFluentImpl.ProvisionRefNestedImpl();
  }
  public ClusterDeploymentStatusFluentImpl.ProvisionRefNested<A> withNewProvisionRefLike(LocalObjectReference item) {
    return new ClusterDeploymentStatusFluentImpl.ProvisionRefNestedImpl(item);
  }
  public ClusterDeploymentStatusFluentImpl.ProvisionRefNested<A> editProvisionRef() {
    return withNewProvisionRefLike(getProvisionRef());
  }
  public ClusterDeploymentStatusFluentImpl.ProvisionRefNested<A> editOrNewProvisionRef() {
    return withNewProvisionRefLike(getProvisionRef() != null ? getProvisionRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterDeploymentStatusFluentImpl.ProvisionRefNested<A> editOrNewProvisionRefLike(LocalObjectReference item) {
    return withNewProvisionRefLike(getProvisionRef() != null ? getProvisionRef(): item);
  }
  public String getWebConsoleURL() {
    return this.webConsoleURL;
  }
  public A withWebConsoleURL(String webConsoleURL) {
    this.webConsoleURL=webConsoleURL; return (A) this;
  }
  public Boolean hasWebConsoleURL() {
    return this.webConsoleURL != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterDeploymentStatusFluentImpl that = (ClusterDeploymentStatusFluentImpl) o;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;

    if (!java.util.Objects.equals(certificateBundles, that.certificateBundles)) return false;

    if (!java.util.Objects.equals(cliImage, that.cliImage)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(installRestarts, that.installRestarts)) return false;

    if (!java.util.Objects.equals(installStartedTimestamp, that.installStartedTimestamp)) return false;

    if (!java.util.Objects.equals(installVersion, that.installVersion)) return false;

    if (!java.util.Objects.equals(installedTimestamp, that.installedTimestamp)) return false;

    if (!java.util.Objects.equals(installerImage, that.installerImage)) return false;

    if (!java.util.Objects.equals(platformStatus, that.platformStatus)) return false;

    if (!java.util.Objects.equals(powerState, that.powerState)) return false;

    if (!java.util.Objects.equals(provisionRef, that.provisionRef)) return false;

    if (!java.util.Objects.equals(webConsoleURL, that.webConsoleURL)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiURL,  certificateBundles,  cliImage,  conditions,  installRestarts,  installStartedTimestamp,  installVersion,  installedTimestamp,  installerImage,  platformStatus,  powerState,  provisionRef,  webConsoleURL,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (certificateBundles != null) { sb.append("certificateBundles:"); sb.append(certificateBundles + ","); }
    if (cliImage != null) { sb.append("cliImage:"); sb.append(cliImage + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (installRestarts != null) { sb.append("installRestarts:"); sb.append(installRestarts + ","); }
    if (installStartedTimestamp != null) { sb.append("installStartedTimestamp:"); sb.append(installStartedTimestamp + ","); }
    if (installVersion != null) { sb.append("installVersion:"); sb.append(installVersion + ","); }
    if (installedTimestamp != null) { sb.append("installedTimestamp:"); sb.append(installedTimestamp + ","); }
    if (installerImage != null) { sb.append("installerImage:"); sb.append(installerImage + ","); }
    if (platformStatus != null) { sb.append("platformStatus:"); sb.append(platformStatus + ","); }
    if (powerState != null) { sb.append("powerState:"); sb.append(powerState + ","); }
    if (provisionRef != null) { sb.append("provisionRef:"); sb.append(provisionRef + ","); }
    if (webConsoleURL != null) { sb.append("webConsoleURL:"); sb.append(webConsoleURL + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CertificateBundlesNestedImpl<N> extends CertificateBundleStatusFluentImpl<ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<N>> implements ClusterDeploymentStatusFluentImpl.CertificateBundlesNested<N>,Nested<N>{
    CertificateBundlesNestedImpl(int index,CertificateBundleStatus item) {
      this.index = index;
      this.builder = new CertificateBundleStatusBuilder(this, item);
    }
    CertificateBundlesNestedImpl() {
      this.index = -1;
      this.builder = new CertificateBundleStatusBuilder(this);
    }
    CertificateBundleStatusBuilder builder;
    int index;
    public N and() {
      return (N) ClusterDeploymentStatusFluentImpl.this.setToCertificateBundles(index,builder.build());
    }
    public N endCertificateBundle() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ClusterDeploymentConditionFluentImpl<ClusterDeploymentStatusFluentImpl.ConditionsNested<N>> implements ClusterDeploymentStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ClusterDeploymentCondition item) {
      this.index = index;
      this.builder = new ClusterDeploymentConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterDeploymentConditionBuilder(this);
    }
    ClusterDeploymentConditionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterDeploymentStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class PlatformStatusNestedImpl<N> extends PlatformStatusFluentImpl<ClusterDeploymentStatusFluentImpl.PlatformStatusNested<N>> implements ClusterDeploymentStatusFluentImpl.PlatformStatusNested<N>,Nested<N>{
    PlatformStatusNestedImpl(PlatformStatus item) {
      this.builder = new PlatformStatusBuilder(this, item);
    }
    PlatformStatusNestedImpl() {
      this.builder = new PlatformStatusBuilder(this);
    }
    PlatformStatusBuilder builder;
    public N and() {
      return (N) ClusterDeploymentStatusFluentImpl.this.withPlatformStatus(builder.build());
    }
    public N endPlatformStatus() {
      return and();
    }
    
  }
  class ProvisionRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterDeploymentStatusFluentImpl.ProvisionRefNested<N>> implements ClusterDeploymentStatusFluentImpl.ProvisionRefNested<N>,Nested<N>{
    ProvisionRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ProvisionRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterDeploymentStatusFluentImpl.this.withProvisionRef(builder.build());
    }
    public N endProvisionRef() {
      return and();
    }
    
  }
  
}