package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeprovisionBuilder extends ClusterDeprovisionFluentImpl<ClusterDeprovisionBuilder> implements VisitableBuilder<ClusterDeprovision,ClusterDeprovisionBuilder>{
  public ClusterDeprovisionBuilder() {
    this(false);
  }
  public ClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new ClusterDeprovision(), validationEnabled);
  }
  public ClusterDeprovisionBuilder(ClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeprovisionBuilder(ClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeprovision(), validationEnabled);
  }
  public ClusterDeprovisionBuilder(ClusterDeprovisionFluent<?> fluent,ClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public ClusterDeprovisionBuilder(ClusterDeprovisionFluent<?> fluent,ClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeprovisionBuilder(ClusterDeprovision instance) {
    this(instance,false);
  }
  public ClusterDeprovisionBuilder(ClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeprovision build() {
    ClusterDeprovision buildable = new ClusterDeprovision(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}