package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterImageSetSpecBuilder extends ClusterImageSetSpecFluentImpl<ClusterImageSetSpecBuilder> implements VisitableBuilder<ClusterImageSetSpec,ClusterImageSetSpecBuilder>{
  public ClusterImageSetSpecBuilder() {
    this(false);
  }
  public ClusterImageSetSpecBuilder(Boolean validationEnabled) {
    this(new ClusterImageSetSpec(), validationEnabled);
  }
  public ClusterImageSetSpecBuilder(ClusterImageSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterImageSetSpecBuilder(ClusterImageSetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterImageSetSpec(), validationEnabled);
  }
  public ClusterImageSetSpecBuilder(ClusterImageSetSpecFluent<?> fluent,ClusterImageSetSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterImageSetSpecBuilder(ClusterImageSetSpecFluent<?> fluent,ClusterImageSetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withReleaseImage(instance.getReleaseImage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterImageSetSpecBuilder(ClusterImageSetSpec instance) {
    this(instance,false);
  }
  public ClusterImageSetSpecBuilder(ClusterImageSetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withReleaseImage(instance.getReleaseImage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterImageSetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterImageSetSpec build() {
    ClusterImageSetSpec buildable = new ClusterImageSetSpec(fluent.getReleaseImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}