package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterIngressFluentImpl<A extends ClusterIngressFluent<A>> extends BaseFluent<A> implements ClusterIngressFluent<A>{
  public ClusterIngressFluentImpl() {
  }
  public ClusterIngressFluentImpl(ClusterIngress instance) {
    if (instance != null) {
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRouteSelector(instance.getRouteSelector());
      this.withServingCertificate(instance.getServingCertificate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String domain;
  private String name;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder routeSelector;
  private String servingCertificate;
  private Map<String,Object> additionalProperties;
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public Boolean hasDomain() {
    return this.domain != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public ClusterIngressFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new ClusterIngressFluentImpl.NamespaceSelectorNestedImpl();
  }
  public ClusterIngressFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new ClusterIngressFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public ClusterIngressFluentImpl.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public ClusterIngressFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public ClusterIngressFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRouteSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public LabelSelector buildRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public A withRouteSelector(LabelSelector routeSelector) {
    _visitables.get("routeSelector").remove(this.routeSelector);
    if (routeSelector!=null){ this.routeSelector= new LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} else { this.routeSelector = null; _visitables.get("routeSelector").remove(this.routeSelector); } return (A) this;
  }
  public Boolean hasRouteSelector() {
    return this.routeSelector != null;
  }
  public ClusterIngressFluentImpl.RouteSelectorNested<A> withNewRouteSelector() {
    return new ClusterIngressFluentImpl.RouteSelectorNestedImpl();
  }
  public ClusterIngressFluentImpl.RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
    return new ClusterIngressFluentImpl.RouteSelectorNestedImpl(item);
  }
  public ClusterIngressFluentImpl.RouteSelectorNested<A> editRouteSelector() {
    return withNewRouteSelectorLike(getRouteSelector());
  }
  public ClusterIngressFluentImpl.RouteSelectorNested<A> editOrNewRouteSelector() {
    return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): new LabelSelectorBuilder().build());
  }
  public ClusterIngressFluentImpl.RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
    return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): item);
  }
  public String getServingCertificate() {
    return this.servingCertificate;
  }
  public A withServingCertificate(String servingCertificate) {
    this.servingCertificate=servingCertificate; return (A) this;
  }
  public Boolean hasServingCertificate() {
    return this.servingCertificate != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterIngressFluentImpl that = (ClusterIngressFluentImpl) o;
    if (!java.util.Objects.equals(domain, that.domain)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(routeSelector, that.routeSelector)) return false;

    if (!java.util.Objects.equals(servingCertificate, that.servingCertificate)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(domain,  name,  namespaceSelector,  routeSelector,  servingCertificate,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (routeSelector != null) { sb.append("routeSelector:"); sb.append(routeSelector + ","); }
    if (servingCertificate != null) { sb.append("servingCertificate:"); sb.append(servingCertificate + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ClusterIngressFluentImpl.NamespaceSelectorNested<N>> implements ClusterIngressFluentImpl.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterIngressFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class RouteSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ClusterIngressFluentImpl.RouteSelectorNested<N>> implements ClusterIngressFluentImpl.RouteSelectorNested<N>,Nested<N>{
    RouteSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RouteSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterIngressFluentImpl.this.withRouteSelector(builder.build());
    }
    public N endRouteSelector() {
      return and();
    }
    
  }
  
}