package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterMetadataFluentImpl<A extends ClusterMetadataFluent<A>> extends BaseFluent<A> implements ClusterMetadataFluent<A>{
  public ClusterMetadataFluentImpl() {
  }
  public ClusterMetadataFluentImpl(ClusterMetadata instance) {
    if (instance != null) {
      this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
      this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
      this.withClusterID(instance.getClusterID());
      this.withInfraID(instance.getInfraID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private LocalObjectReferenceBuilder adminKubeconfigSecretRef;
  private LocalObjectReferenceBuilder adminPasswordSecretRef;
  private String clusterID;
  private String infraID;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAdminKubeconfigSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef!=null ?this.adminKubeconfigSecretRef.build():null;
  }
  public LocalObjectReference buildAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef!=null ?this.adminKubeconfigSecretRef.build():null;
  }
  public A withAdminKubeconfigSecretRef(LocalObjectReference adminKubeconfigSecretRef) {
    _visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef);
    if (adminKubeconfigSecretRef!=null){ this.adminKubeconfigSecretRef= new LocalObjectReferenceBuilder(adminKubeconfigSecretRef); _visitables.get("adminKubeconfigSecretRef").add(this.adminKubeconfigSecretRef);} else { this.adminKubeconfigSecretRef = null; _visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef); } return (A) this;
  }
  public Boolean hasAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef != null;
  }
  public A withNewAdminKubeconfigSecretRef(String name) {
    return (A)withAdminKubeconfigSecretRef(new LocalObjectReference(name));
  }
  public ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRef() {
    return new ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNestedImpl();
  }
  public ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return new ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNestedImpl(item);
  }
  public ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<A> editAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(getAdminKubeconfigSecretRef());
  }
  public ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(getAdminKubeconfigSecretRef() != null ? getAdminKubeconfigSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return withNewAdminKubeconfigSecretRefLike(getAdminKubeconfigSecretRef() != null ? getAdminKubeconfigSecretRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAdminPasswordSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef!=null ?this.adminPasswordSecretRef.build():null;
  }
  public LocalObjectReference buildAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef!=null ?this.adminPasswordSecretRef.build():null;
  }
  public A withAdminPasswordSecretRef(LocalObjectReference adminPasswordSecretRef) {
    _visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef);
    if (adminPasswordSecretRef!=null){ this.adminPasswordSecretRef= new LocalObjectReferenceBuilder(adminPasswordSecretRef); _visitables.get("adminPasswordSecretRef").add(this.adminPasswordSecretRef);} else { this.adminPasswordSecretRef = null; _visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef); } return (A) this;
  }
  public Boolean hasAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef != null;
  }
  public A withNewAdminPasswordSecretRef(String name) {
    return (A)withAdminPasswordSecretRef(new LocalObjectReference(name));
  }
  public ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRef() {
    return new ClusterMetadataFluentImpl.AdminPasswordSecretRefNestedImpl();
  }
  public ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return new ClusterMetadataFluentImpl.AdminPasswordSecretRefNestedImpl(item);
  }
  public ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<A> editAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(getAdminPasswordSecretRef());
  }
  public ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(getAdminPasswordSecretRef() != null ? getAdminPasswordSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return withNewAdminPasswordSecretRefLike(getAdminPasswordSecretRef() != null ? getAdminPasswordSecretRef(): item);
  }
  public String getClusterID() {
    return this.clusterID;
  }
  public A withClusterID(String clusterID) {
    this.clusterID=clusterID; return (A) this;
  }
  public Boolean hasClusterID() {
    return this.clusterID != null;
  }
  public String getInfraID() {
    return this.infraID;
  }
  public A withInfraID(String infraID) {
    this.infraID=infraID; return (A) this;
  }
  public Boolean hasInfraID() {
    return this.infraID != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterMetadataFluentImpl that = (ClusterMetadataFluentImpl) o;
    if (!java.util.Objects.equals(adminKubeconfigSecretRef, that.adminKubeconfigSecretRef)) return false;

    if (!java.util.Objects.equals(adminPasswordSecretRef, that.adminPasswordSecretRef)) return false;

    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;

    if (!java.util.Objects.equals(infraID, that.infraID)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(adminKubeconfigSecretRef,  adminPasswordSecretRef,  clusterID,  infraID,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (adminKubeconfigSecretRef != null) { sb.append("adminKubeconfigSecretRef:"); sb.append(adminKubeconfigSecretRef + ","); }
    if (adminPasswordSecretRef != null) { sb.append("adminPasswordSecretRef:"); sb.append(adminPasswordSecretRef + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (infraID != null) { sb.append("infraID:"); sb.append(infraID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AdminKubeconfigSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<N>> implements ClusterMetadataFluentImpl.AdminKubeconfigSecretRefNested<N>,Nested<N>{
    AdminKubeconfigSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    AdminKubeconfigSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterMetadataFluentImpl.this.withAdminKubeconfigSecretRef(builder.build());
    }
    public N endAdminKubeconfigSecretRef() {
      return and();
    }
    
  }
  class AdminPasswordSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<N>> implements ClusterMetadataFluentImpl.AdminPasswordSecretRefNested<N>,Nested<N>{
    AdminPasswordSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    AdminPasswordSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterMetadataFluentImpl.this.withAdminPasswordSecretRef(builder.build());
    }
    public N endAdminPasswordSecretRef() {
      return and();
    }
    
  }
  
}