package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterProvisionConditionBuilder extends ClusterProvisionConditionFluentImpl<ClusterProvisionConditionBuilder> implements VisitableBuilder<ClusterProvisionCondition,ClusterProvisionConditionBuilder>{
  public ClusterProvisionConditionBuilder() {
    this(false);
  }
  public ClusterProvisionConditionBuilder(Boolean validationEnabled) {
    this(new ClusterProvisionCondition(), validationEnabled);
  }
  public ClusterProvisionConditionBuilder(ClusterProvisionConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterProvisionConditionBuilder(ClusterProvisionConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterProvisionCondition(), validationEnabled);
  }
  public ClusterProvisionConditionBuilder(ClusterProvisionConditionFluent<?> fluent,ClusterProvisionCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterProvisionConditionBuilder(ClusterProvisionConditionFluent<?> fluent,ClusterProvisionCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterProvisionConditionBuilder(ClusterProvisionCondition instance) {
    this(instance,false);
  }
  public ClusterProvisionConditionBuilder(ClusterProvisionCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterProvisionConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterProvisionCondition build() {
    ClusterProvisionCondition buildable = new ClusterProvisionCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}