package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterProvisionSpecBuilder extends ClusterProvisionSpecFluentImpl<ClusterProvisionSpecBuilder> implements VisitableBuilder<ClusterProvisionSpec,ClusterProvisionSpecBuilder>{
  public ClusterProvisionSpecBuilder() {
    this(false);
  }
  public ClusterProvisionSpecBuilder(Boolean validationEnabled) {
    this(new ClusterProvisionSpec(), validationEnabled);
  }
  public ClusterProvisionSpecBuilder(ClusterProvisionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterProvisionSpecBuilder(ClusterProvisionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterProvisionSpec(), validationEnabled);
  }
  public ClusterProvisionSpecBuilder(ClusterProvisionSpecFluent<?> fluent,ClusterProvisionSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterProvisionSpecBuilder(ClusterProvisionSpecFluent<?> fluent,ClusterProvisionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
      fluent.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
      fluent.withAttempt(instance.getAttempt());
      fluent.withClusterDeploymentRef(instance.getClusterDeploymentRef());
      fluent.withClusterID(instance.getClusterID());
      fluent.withInfraID(instance.getInfraID());
      fluent.withInstallLog(instance.getInstallLog());
      fluent.withMetadata(instance.getMetadata());
      fluent.withPodSpec(instance.getPodSpec());
      fluent.withPrevClusterID(instance.getPrevClusterID());
      fluent.withPrevInfraID(instance.getPrevInfraID());
      fluent.withStage(instance.getStage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterProvisionSpecBuilder(ClusterProvisionSpec instance) {
    this(instance,false);
  }
  public ClusterProvisionSpecBuilder(ClusterProvisionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
      this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
      this.withAttempt(instance.getAttempt());
      this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
      this.withClusterID(instance.getClusterID());
      this.withInfraID(instance.getInfraID());
      this.withInstallLog(instance.getInstallLog());
      this.withMetadata(instance.getMetadata());
      this.withPodSpec(instance.getPodSpec());
      this.withPrevClusterID(instance.getPrevClusterID());
      this.withPrevInfraID(instance.getPrevInfraID());
      this.withStage(instance.getStage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterProvisionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterProvisionSpec build() {
    ClusterProvisionSpec buildable = new ClusterProvisionSpec(fluent.getAdminKubeconfigSecretRef(),fluent.getAdminPasswordSecretRef(),fluent.getAttempt(),fluent.getClusterDeploymentRef(),fluent.getClusterID(),fluent.getInfraID(),fluent.getInstallLog(),fluent.getMetadata(),fluent.getPodSpec(),fluent.getPrevClusterID(),fluent.getPrevInfraID(),fluent.getStage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}