package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterStateFluent<A extends ClusterStateFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ClusterStateFluent.MetadataNested<A> withNewMetadata();
  public ClusterStateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ClusterStateFluent.MetadataNested<A> editMetadata();
  public ClusterStateFluent.MetadataNested<A> editOrNewMetadata();
  public ClusterStateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterStateSpec getSpec();
  public ClusterStateSpec buildSpec();
  public A withSpec(ClusterStateSpec spec);
  public Boolean hasSpec();
  public ClusterStateFluent.SpecNested<A> withNewSpec();
  public ClusterStateFluent.SpecNested<A> withNewSpecLike(ClusterStateSpec item);
  public ClusterStateFluent.SpecNested<A> editSpec();
  public ClusterStateFluent.SpecNested<A> editOrNewSpec();
  public ClusterStateFluent.SpecNested<A> editOrNewSpecLike(ClusterStateSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterStateStatus getStatus();
  public ClusterStateStatus buildStatus();
  public A withStatus(ClusterStateStatus status);
  public Boolean hasStatus();
  public ClusterStateFluent.StatusNested<A> withNewStatus();
  public ClusterStateFluent.StatusNested<A> withNewStatusLike(ClusterStateStatus item);
  public ClusterStateFluent.StatusNested<A> editStatus();
  public ClusterStateFluent.StatusNested<A> editOrNewStatus();
  public ClusterStateFluent.StatusNested<A> editOrNewStatusLike(ClusterStateStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ClusterStateFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ClusterStateSpecFluent<ClusterStateFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ClusterStateStatusFluent<ClusterStateFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}