package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterStateListBuilder extends ClusterStateListFluentImpl<ClusterStateListBuilder> implements VisitableBuilder<ClusterStateList,ClusterStateListBuilder>{
  public ClusterStateListBuilder() {
    this(false);
  }
  public ClusterStateListBuilder(Boolean validationEnabled) {
    this(new ClusterStateList(), validationEnabled);
  }
  public ClusterStateListBuilder(ClusterStateListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterStateListBuilder(ClusterStateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterStateList(), validationEnabled);
  }
  public ClusterStateListBuilder(ClusterStateListFluent<?> fluent,ClusterStateList instance) {
    this(fluent, instance, false);
  }
  public ClusterStateListBuilder(ClusterStateListFluent<?> fluent,ClusterStateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterStateListBuilder(ClusterStateList instance) {
    this(instance,false);
  }
  public ClusterStateListBuilder(ClusterStateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterStateListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterStateList build() {
    ClusterStateList buildable = new ClusterStateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}