package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControlPlaneConfigSpecBuilder extends ControlPlaneConfigSpecFluentImpl<ControlPlaneConfigSpecBuilder> implements VisitableBuilder<ControlPlaneConfigSpec,ControlPlaneConfigSpecBuilder>{
  public ControlPlaneConfigSpecBuilder() {
    this(false);
  }
  public ControlPlaneConfigSpecBuilder(Boolean validationEnabled) {
    this(new ControlPlaneConfigSpec(), validationEnabled);
  }
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControlPlaneConfigSpec(), validationEnabled);
  }
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpecFluent<?> fluent,ControlPlaneConfigSpec instance) {
    this(fluent, instance, false);
  }
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpecFluent<?> fluent,ControlPlaneConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiURLOverride(instance.getApiURLOverride());
      fluent.withServingCertificates(instance.getServingCertificates());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpec instance) {
    this(instance,false);
  }
  public ControlPlaneConfigSpecBuilder(ControlPlaneConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiURLOverride(instance.getApiURLOverride());
      this.withServingCertificates(instance.getServingCertificates());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ControlPlaneConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ControlPlaneConfigSpec build() {
    ControlPlaneConfigSpec buildable = new ControlPlaneConfigSpec(fluent.getApiURLOverride(),fluent.getServingCertificates());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}