package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ControllersConfigFluentImpl<A extends ControllersConfigFluent<A>> extends BaseFluent<A> implements ControllersConfigFluent<A>{
  public ControllersConfigFluentImpl() {
  }
  public ControllersConfigFluentImpl(ControllersConfig instance) {
    if (instance != null) {
      this.withControllers(instance.getControllers());
      this.withDefault(instance.getDefault());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<SpecificControllerConfigBuilder> controllers = new ArrayList<SpecificControllerConfigBuilder>();
  private ControllerConfigBuilder _default;
  private Map<String,Object> additionalProperties;
  public A addToControllers(int index,SpecificControllerConfig item) {
    if (this.controllers == null) {this.controllers = new ArrayList<SpecificControllerConfigBuilder>();}
    SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
    if (index < 0 || index >= controllers.size()) { _visitables.get("controllers").add(builder); controllers.add(builder); } else { _visitables.get("controllers").add(index, builder); controllers.add(index, builder);}
    return (A)this;
  }
  public A setToControllers(int index,SpecificControllerConfig item) {
    if (this.controllers == null) {this.controllers = new ArrayList<SpecificControllerConfigBuilder>();}
    SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
    if (index < 0 || index >= controllers.size()) { _visitables.get("controllers").add(builder); controllers.add(builder); } else { _visitables.get("controllers").set(index, builder); controllers.set(index, builder);}
    return (A)this;
  }
  public A addToControllers(io.fabric8.openshift.api.model.hive.v1.SpecificControllerConfig... items) {
    if (this.controllers == null) {this.controllers = new ArrayList<SpecificControllerConfigBuilder>();}
    for (SpecificControllerConfig item : items) {SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);_visitables.get("controllers").add(builder);this.controllers.add(builder);} return (A)this;
  }
  public A addAllToControllers(Collection<SpecificControllerConfig> items) {
    if (this.controllers == null) {this.controllers = new ArrayList<SpecificControllerConfigBuilder>();}
    for (SpecificControllerConfig item : items) {SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);_visitables.get("controllers").add(builder);this.controllers.add(builder);} return (A)this;
  }
  public A removeFromControllers(io.fabric8.openshift.api.model.hive.v1.SpecificControllerConfig... items) {
    for (SpecificControllerConfig item : items) {SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);_visitables.get("controllers").remove(builder);if (this.controllers != null) {this.controllers.remove(builder);}} return (A)this;
  }
  public A removeAllFromControllers(Collection<SpecificControllerConfig> items) {
    for (SpecificControllerConfig item : items) {SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);_visitables.get("controllers").remove(builder);if (this.controllers != null) {this.controllers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromControllers(Predicate<SpecificControllerConfigBuilder> predicate) {
    if (controllers == null) return (A) this;
    final Iterator<SpecificControllerConfigBuilder> each = controllers.iterator();
    final List visitables = _visitables.get("controllers");
    while (each.hasNext()) {
      SpecificControllerConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildControllers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SpecificControllerConfig> getControllers() {
    return controllers != null ? build(controllers) : null;
  }
  public List<SpecificControllerConfig> buildControllers() {
    return controllers != null ? build(controllers) : null;
  }
  public SpecificControllerConfig buildController(int index) {
    return this.controllers.get(index).build();
  }
  public SpecificControllerConfig buildFirstController() {
    return this.controllers.get(0).build();
  }
  public SpecificControllerConfig buildLastController() {
    return this.controllers.get(controllers.size() - 1).build();
  }
  public SpecificControllerConfig buildMatchingController(Predicate<SpecificControllerConfigBuilder> predicate) {
    for (SpecificControllerConfigBuilder item: controllers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingController(Predicate<SpecificControllerConfigBuilder> predicate) {
    for (SpecificControllerConfigBuilder item: controllers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withControllers(List<SpecificControllerConfig> controllers) {
    if (this.controllers != null) { _visitables.get("controllers").clear();}
    if (controllers != null) {this.controllers = new ArrayList(); for (SpecificControllerConfig item : controllers){this.addToControllers(item);}} else { this.controllers = null;} return (A) this;
  }
  public A withControllers(io.fabric8.openshift.api.model.hive.v1.SpecificControllerConfig... controllers) {
    if (this.controllers != null) {this.controllers.clear(); _visitables.remove("controllers"); }
    if (controllers != null) {for (SpecificControllerConfig item :controllers){ this.addToControllers(item);}} return (A) this;
  }
  public Boolean hasControllers() {
    return controllers != null && !controllers.isEmpty();
  }
  public ControllersConfigFluentImpl.ControllersNested<A> addNewController() {
    return new ControllersConfigFluentImpl.ControllersNestedImpl();
  }
  public ControllersConfigFluentImpl.ControllersNested<A> addNewControllerLike(SpecificControllerConfig item) {
    return new ControllersConfigFluentImpl.ControllersNestedImpl(-1, item);
  }
  public ControllersConfigFluentImpl.ControllersNested<A> setNewControllerLike(int index,SpecificControllerConfig item) {
    return new ControllersConfigFluentImpl.ControllersNestedImpl(index, item);
  }
  public ControllersConfigFluentImpl.ControllersNested<A> editController(int index) {
    if (controllers.size() <= index) throw new RuntimeException("Can't edit controllers. Index exceeds size.");
    return setNewControllerLike(index, buildController(index));
  }
  public ControllersConfigFluentImpl.ControllersNested<A> editFirstController() {
    if (controllers.size() == 0) throw new RuntimeException("Can't edit first controllers. The list is empty.");
    return setNewControllerLike(0, buildController(0));
  }
  public ControllersConfigFluentImpl.ControllersNested<A> editLastController() {
    int index = controllers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last controllers. The list is empty.");
    return setNewControllerLike(index, buildController(index));
  }
  public ControllersConfigFluentImpl.ControllersNested<A> editMatchingController(Predicate<SpecificControllerConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<controllers.size();i++) { 
    if (predicate.test(controllers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching controllers. No match found.");
    return setNewControllerLike(index, buildController(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDefault instead.
   * @return The buildable object.
   */
  @Deprecated
  public ControllerConfig getDefault() {
    return this._default!=null ?this._default.build():null;
  }
  public ControllerConfig buildDefault() {
    return this._default!=null ?this._default.build():null;
  }
  public A withDefault(ControllerConfig _default) {
    _visitables.get("_default").remove(this._default);
    if (_default!=null){ this._default= new ControllerConfigBuilder(_default); _visitables.get("_default").add(this._default);} else { this._default = null; _visitables.get("_default").remove(this._default); } return (A) this;
  }
  public Boolean hasDefault() {
    return this._default != null;
  }
  public ControllersConfigFluentImpl.DefaultNested<A> withNewDefault() {
    return new ControllersConfigFluentImpl.DefaultNestedImpl();
  }
  public ControllersConfigFluentImpl.DefaultNested<A> withNewDefaultLike(ControllerConfig item) {
    return new ControllersConfigFluentImpl.DefaultNestedImpl(item);
  }
  public ControllersConfigFluentImpl.DefaultNested<A> editDefault() {
    return withNewDefaultLike(getDefault());
  }
  public ControllersConfigFluentImpl.DefaultNested<A> editOrNewDefault() {
    return withNewDefaultLike(getDefault() != null ? getDefault(): new ControllerConfigBuilder().build());
  }
  public ControllersConfigFluentImpl.DefaultNested<A> editOrNewDefaultLike(ControllerConfig item) {
    return withNewDefaultLike(getDefault() != null ? getDefault(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControllersConfigFluentImpl that = (ControllersConfigFluentImpl) o;
    if (!java.util.Objects.equals(controllers, that.controllers)) return false;

    if (!java.util.Objects.equals(_default, that._default)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(controllers,  _default,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controllers != null) { sb.append("controllers:"); sb.append(controllers + ","); }
    if (_default != null) { sb.append("_default:"); sb.append(_default + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ControllersNestedImpl<N> extends SpecificControllerConfigFluentImpl<ControllersConfigFluentImpl.ControllersNested<N>> implements ControllersConfigFluentImpl.ControllersNested<N>,Nested<N>{
    ControllersNestedImpl(int index,SpecificControllerConfig item) {
      this.index = index;
      this.builder = new SpecificControllerConfigBuilder(this, item);
    }
    ControllersNestedImpl() {
      this.index = -1;
      this.builder = new SpecificControllerConfigBuilder(this);
    }
    SpecificControllerConfigBuilder builder;
    int index;
    public N and() {
      return (N) ControllersConfigFluentImpl.this.setToControllers(index,builder.build());
    }
    public N endController() {
      return and();
    }
    
  }
  class DefaultNestedImpl<N> extends ControllerConfigFluentImpl<ControllersConfigFluentImpl.DefaultNested<N>> implements ControllersConfigFluentImpl.DefaultNested<N>,Nested<N>{
    DefaultNestedImpl(ControllerConfig item) {
      this.builder = new ControllerConfigBuilder(this, item);
    }
    DefaultNestedImpl() {
      this.builder = new ControllerConfigBuilder(this);
    }
    ControllerConfigBuilder builder;
    public N and() {
      return (N) ControllersConfigFluentImpl.this.withDefault(builder.build());
    }
    public N endDefault() {
      return and();
    }
    
  }
  
}