package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneBuilder extends DNSZoneFluentImpl<DNSZoneBuilder> implements VisitableBuilder<DNSZone,DNSZoneBuilder>{
  public DNSZoneBuilder() {
    this(false);
  }
  public DNSZoneBuilder(Boolean validationEnabled) {
    this(new DNSZone(), validationEnabled);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZone(), validationEnabled);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent,DNSZone instance) {
    this(fluent, instance, false);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent,DNSZone instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneBuilder(DNSZone instance) {
    this(instance,false);
  }
  public DNSZoneBuilder(DNSZone instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSZoneFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZone build() {
    DNSZone buildable = new DNSZone(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}