package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneSpecBuilder extends DNSZoneSpecFluentImpl<DNSZoneSpecBuilder> implements VisitableBuilder<DNSZoneSpec,DNSZoneSpecBuilder>{
  public DNSZoneSpecBuilder() {
    this(false);
  }
  public DNSZoneSpecBuilder(Boolean validationEnabled) {
    this(new DNSZoneSpec(), validationEnabled);
  }
  public DNSZoneSpecBuilder(DNSZoneSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneSpecBuilder(DNSZoneSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZoneSpec(), validationEnabled);
  }
  public DNSZoneSpecBuilder(DNSZoneSpecFluent<?> fluent,DNSZoneSpec instance) {
    this(fluent, instance, false);
  }
  public DNSZoneSpecBuilder(DNSZoneSpecFluent<?> fluent,DNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withGcp(instance.getGcp());
      fluent.withLinkToParentDomain(instance.getLinkToParentDomain());
      fluent.withPreserveOnDelete(instance.getPreserveOnDelete());
      fluent.withZone(instance.getZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneSpecBuilder(DNSZoneSpec instance) {
    this(instance,false);
  }
  public DNSZoneSpecBuilder(DNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withLinkToParentDomain(instance.getLinkToParentDomain());
      this.withPreserveOnDelete(instance.getPreserveOnDelete());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSZoneSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZoneSpec build() {
    DNSZoneSpec buildable = new DNSZoneSpec(fluent.getAws(),fluent.getAzure(),fluent.getGcp(),fluent.getLinkToParentDomain(),fluent.getPreserveOnDelete(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}