package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSZoneSpecFluentImpl<A extends DNSZoneSpecFluent<A>> extends BaseFluent<A> implements DNSZoneSpecFluent<A>{
  public DNSZoneSpecFluentImpl() {
  }
  public DNSZoneSpecFluentImpl(DNSZoneSpec instance) {
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withLinkToParentDomain(instance.getLinkToParentDomain());
      this.withPreserveOnDelete(instance.getPreserveOnDelete());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AWSDNSZoneSpecBuilder aws;
  private AzureDNSZoneSpecBuilder azure;
  private GCPDNSZoneSpecBuilder gcp;
  private Boolean linkToParentDomain;
  private Boolean preserveOnDelete;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSDNSZoneSpec getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public AWSDNSZoneSpec buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSDNSZoneSpec aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSDNSZoneSpecBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public DNSZoneSpecFluentImpl.AwsNested<A> withNewAws() {
    return new DNSZoneSpecFluentImpl.AwsNestedImpl();
  }
  public DNSZoneSpecFluentImpl.AwsNested<A> withNewAwsLike(AWSDNSZoneSpec item) {
    return new DNSZoneSpecFluentImpl.AwsNestedImpl(item);
  }
  public DNSZoneSpecFluentImpl.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public DNSZoneSpecFluentImpl.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new AWSDNSZoneSpecBuilder().build());
  }
  public DNSZoneSpecFluentImpl.AwsNested<A> editOrNewAwsLike(AWSDNSZoneSpec item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @Deprecated
  public AzureDNSZoneSpec getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public AzureDNSZoneSpec buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(AzureDNSZoneSpec azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzureDNSZoneSpecBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public Boolean hasAzure() {
    return this.azure != null;
  }
  public DNSZoneSpecFluentImpl.AzureNested<A> withNewAzure() {
    return new DNSZoneSpecFluentImpl.AzureNestedImpl();
  }
  public DNSZoneSpecFluentImpl.AzureNested<A> withNewAzureLike(AzureDNSZoneSpec item) {
    return new DNSZoneSpecFluentImpl.AzureNestedImpl(item);
  }
  public DNSZoneSpecFluentImpl.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public DNSZoneSpecFluentImpl.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new AzureDNSZoneSpecBuilder().build());
  }
  public DNSZoneSpecFluentImpl.AzureNested<A> editOrNewAzureLike(AzureDNSZoneSpec item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @Deprecated
  public GCPDNSZoneSpec getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public GCPDNSZoneSpec buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPDNSZoneSpec gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPDNSZoneSpecBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public Boolean hasGcp() {
    return this.gcp != null;
  }
  public DNSZoneSpecFluentImpl.GcpNested<A> withNewGcp() {
    return new DNSZoneSpecFluentImpl.GcpNestedImpl();
  }
  public DNSZoneSpecFluentImpl.GcpNested<A> withNewGcpLike(GCPDNSZoneSpec item) {
    return new DNSZoneSpecFluentImpl.GcpNestedImpl(item);
  }
  public DNSZoneSpecFluentImpl.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public DNSZoneSpecFluentImpl.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new GCPDNSZoneSpecBuilder().build());
  }
  public DNSZoneSpecFluentImpl.GcpNested<A> editOrNewGcpLike(GCPDNSZoneSpec item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  public Boolean getLinkToParentDomain() {
    return this.linkToParentDomain;
  }
  public A withLinkToParentDomain(Boolean linkToParentDomain) {
    this.linkToParentDomain=linkToParentDomain; return (A) this;
  }
  public Boolean hasLinkToParentDomain() {
    return this.linkToParentDomain != null;
  }
  public Boolean getPreserveOnDelete() {
    return this.preserveOnDelete;
  }
  public A withPreserveOnDelete(Boolean preserveOnDelete) {
    this.preserveOnDelete=preserveOnDelete; return (A) this;
  }
  public Boolean hasPreserveOnDelete() {
    return this.preserveOnDelete != null;
  }
  public String getZone() {
    return this.zone;
  }
  public A withZone(String zone) {
    this.zone=zone; return (A) this;
  }
  public Boolean hasZone() {
    return this.zone != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSZoneSpecFluentImpl that = (DNSZoneSpecFluentImpl) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;

    if (!java.util.Objects.equals(azure, that.azure)) return false;

    if (!java.util.Objects.equals(gcp, that.gcp)) return false;

    if (!java.util.Objects.equals(linkToParentDomain, that.linkToParentDomain)) return false;

    if (!java.util.Objects.equals(preserveOnDelete, that.preserveOnDelete)) return false;

    if (!java.util.Objects.equals(zone, that.zone)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  gcp,  linkToParentDomain,  preserveOnDelete,  zone,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (linkToParentDomain != null) { sb.append("linkToParentDomain:"); sb.append(linkToParentDomain + ","); }
    if (preserveOnDelete != null) { sb.append("preserveOnDelete:"); sb.append(preserveOnDelete + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withLinkToParentDomain() {
    return withLinkToParentDomain(true);
  }
  public A withPreserveOnDelete() {
    return withPreserveOnDelete(true);
  }
  class AwsNestedImpl<N> extends AWSDNSZoneSpecFluentImpl<DNSZoneSpecFluentImpl.AwsNested<N>> implements DNSZoneSpecFluentImpl.AwsNested<N>,Nested<N>{
    AwsNestedImpl(AWSDNSZoneSpec item) {
      this.builder = new AWSDNSZoneSpecBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new AWSDNSZoneSpecBuilder(this);
    }
    AWSDNSZoneSpecBuilder builder;
    public N and() {
      return (N) DNSZoneSpecFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class AzureNestedImpl<N> extends AzureDNSZoneSpecFluentImpl<DNSZoneSpecFluentImpl.AzureNested<N>> implements DNSZoneSpecFluentImpl.AzureNested<N>,Nested<N>{
    AzureNestedImpl(AzureDNSZoneSpec item) {
      this.builder = new AzureDNSZoneSpecBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new AzureDNSZoneSpecBuilder(this);
    }
    AzureDNSZoneSpecBuilder builder;
    public N and() {
      return (N) DNSZoneSpecFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends GCPDNSZoneSpecFluentImpl<DNSZoneSpecFluentImpl.GcpNested<N>> implements DNSZoneSpecFluentImpl.GcpNested<N>,Nested<N>{
    GcpNestedImpl(GCPDNSZoneSpec item) {
      this.builder = new GCPDNSZoneSpecBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new GCPDNSZoneSpecBuilder(this);
    }
    GCPDNSZoneSpecBuilder builder;
    public N and() {
      return (N) DNSZoneSpecFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  
}