package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneStatusBuilder extends DNSZoneStatusFluentImpl<DNSZoneStatusBuilder> implements VisitableBuilder<DNSZoneStatus,DNSZoneStatusBuilder>{
  public DNSZoneStatusBuilder() {
    this(false);
  }
  public DNSZoneStatusBuilder(Boolean validationEnabled) {
    this(new DNSZoneStatus(), validationEnabled);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZoneStatus(), validationEnabled);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,DNSZoneStatus instance) {
    this(fluent, instance, false);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,DNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withConditions(instance.getConditions());
      fluent.withGcp(instance.getGcp());
      fluent.withLastSyncGeneration(instance.getLastSyncGeneration());
      fluent.withLastSyncTimestamp(instance.getLastSyncTimestamp());
      fluent.withNameServers(instance.getNameServers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneStatusBuilder(DNSZoneStatus instance) {
    this(instance,false);
  }
  public DNSZoneStatusBuilder(DNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withConditions(instance.getConditions());
      this.withGcp(instance.getGcp());
      this.withLastSyncGeneration(instance.getLastSyncGeneration());
      this.withLastSyncTimestamp(instance.getLastSyncTimestamp());
      this.withNameServers(instance.getNameServers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSZoneStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZoneStatus build() {
    DNSZoneStatus buildable = new DNSZoneStatus(fluent.getAws(),fluent.getAzure(),fluent.getConditions(),fluent.getGcp(),fluent.getLastSyncGeneration(),fluent.getLastSyncTimestamp(),fluent.getNameServers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}