package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSZoneStatusFluentImpl<A extends DNSZoneStatusFluent<A>> extends BaseFluent<A> implements DNSZoneStatusFluent<A>{
  public DNSZoneStatusFluentImpl() {
  }
  public DNSZoneStatusFluentImpl(DNSZoneStatus instance) {
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withConditions(instance.getConditions());
      this.withGcp(instance.getGcp());
      this.withLastSyncGeneration(instance.getLastSyncGeneration());
      this.withLastSyncTimestamp(instance.getLastSyncTimestamp());
      this.withNameServers(instance.getNameServers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AWSDNSZoneStatusBuilder aws;
  private AzureDNSZoneStatusBuilder azure;
  private ArrayList<DNSZoneConditionBuilder> conditions = new ArrayList<DNSZoneConditionBuilder>();
  private GCPDNSZoneStatusBuilder gcp;
  private Long lastSyncGeneration;
  private String lastSyncTimestamp;
  private List<String> nameServers = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSDNSZoneStatus getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public AWSDNSZoneStatus buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSDNSZoneStatus aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSDNSZoneStatusBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public A withNewAws(String zoneID) {
    return (A)withAws(new AWSDNSZoneStatus(zoneID));
  }
  public DNSZoneStatusFluentImpl.AwsNested<A> withNewAws() {
    return new DNSZoneStatusFluentImpl.AwsNestedImpl();
  }
  public DNSZoneStatusFluentImpl.AwsNested<A> withNewAwsLike(AWSDNSZoneStatus item) {
    return new DNSZoneStatusFluentImpl.AwsNestedImpl(item);
  }
  public DNSZoneStatusFluentImpl.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public DNSZoneStatusFluentImpl.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new AWSDNSZoneStatusBuilder().build());
  }
  public DNSZoneStatusFluentImpl.AwsNested<A> editOrNewAwsLike(AWSDNSZoneStatus item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @Deprecated
  public AzureDNSZoneStatus getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public AzureDNSZoneStatus buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(AzureDNSZoneStatus azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzureDNSZoneStatusBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public Boolean hasAzure() {
    return this.azure != null;
  }
  public DNSZoneStatusFluentImpl.AzureNested<A> withNewAzure() {
    return new DNSZoneStatusFluentImpl.AzureNestedImpl();
  }
  public DNSZoneStatusFluentImpl.AzureNested<A> withNewAzureLike(AzureDNSZoneStatus item) {
    return new DNSZoneStatusFluentImpl.AzureNestedImpl(item);
  }
  public DNSZoneStatusFluentImpl.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public DNSZoneStatusFluentImpl.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new AzureDNSZoneStatusBuilder().build());
  }
  public DNSZoneStatusFluentImpl.AzureNested<A> editOrNewAzureLike(AzureDNSZoneStatus item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  public A addToConditions(int index,DNSZoneCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,DNSZoneCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.DNSZoneCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<DNSZoneCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.DNSZoneCondition... items) {
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<DNSZoneCondition> items) {
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<DNSZoneConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<DNSZoneConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      DNSZoneConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DNSZoneCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<DNSZoneCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public DNSZoneCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public DNSZoneCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public DNSZoneCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public DNSZoneCondition buildMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
    for (DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
    for (DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<DNSZoneCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (DNSZoneCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.DNSZoneCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (DNSZoneCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new DNSZoneStatusFluentImpl.ConditionsNestedImpl();
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> addNewConditionLike(DNSZoneCondition item) {
    return new DNSZoneStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,DNSZoneCondition item) {
    return new DNSZoneStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DNSZoneStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @Deprecated
  public GCPDNSZoneStatus getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public GCPDNSZoneStatus buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPDNSZoneStatus gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPDNSZoneStatusBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public Boolean hasGcp() {
    return this.gcp != null;
  }
  public A withNewGcp(String zoneName) {
    return (A)withGcp(new GCPDNSZoneStatus(zoneName));
  }
  public DNSZoneStatusFluentImpl.GcpNested<A> withNewGcp() {
    return new DNSZoneStatusFluentImpl.GcpNestedImpl();
  }
  public DNSZoneStatusFluentImpl.GcpNested<A> withNewGcpLike(GCPDNSZoneStatus item) {
    return new DNSZoneStatusFluentImpl.GcpNestedImpl(item);
  }
  public DNSZoneStatusFluentImpl.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public DNSZoneStatusFluentImpl.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new GCPDNSZoneStatusBuilder().build());
  }
  public DNSZoneStatusFluentImpl.GcpNested<A> editOrNewGcpLike(GCPDNSZoneStatus item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  public Long getLastSyncGeneration() {
    return this.lastSyncGeneration;
  }
  public A withLastSyncGeneration(Long lastSyncGeneration) {
    this.lastSyncGeneration=lastSyncGeneration; return (A) this;
  }
  public Boolean hasLastSyncGeneration() {
    return this.lastSyncGeneration != null;
  }
  public String getLastSyncTimestamp() {
    return this.lastSyncTimestamp;
  }
  public A withLastSyncTimestamp(String lastSyncTimestamp) {
    this.lastSyncTimestamp=lastSyncTimestamp; return (A) this;
  }
  public Boolean hasLastSyncTimestamp() {
    return this.lastSyncTimestamp != null;
  }
  public A addToNameServers(int index,String item) {
    if (this.nameServers == null) {this.nameServers = new ArrayList<String>();}
    this.nameServers.add(index, item);
    return (A)this;
  }
  public A setToNameServers(int index,String item) {
    if (this.nameServers == null) {this.nameServers = new ArrayList<String>();}
    this.nameServers.set(index, item); return (A)this;
  }
  public A addToNameServers(java.lang.String... items) {
    if (this.nameServers == null) {this.nameServers = new ArrayList<String>();}
    for (String item : items) {this.nameServers.add(item);} return (A)this;
  }
  public A addAllToNameServers(Collection<String> items) {
    if (this.nameServers == null) {this.nameServers = new ArrayList<String>();}
    for (String item : items) {this.nameServers.add(item);} return (A)this;
  }
  public A removeFromNameServers(java.lang.String... items) {
    for (String item : items) {if (this.nameServers!= null){ this.nameServers.remove(item);}} return (A)this;
  }
  public A removeAllFromNameServers(Collection<String> items) {
    for (String item : items) {if (this.nameServers!= null){ this.nameServers.remove(item);}} return (A)this;
  }
  public List<String> getNameServers() {
    return this.nameServers;
  }
  public String getNameServer(int index) {
    return this.nameServers.get(index);
  }
  public String getFirstNameServer() {
    return this.nameServers.get(0);
  }
  public String getLastNameServer() {
    return this.nameServers.get(nameServers.size() - 1);
  }
  public String getMatchingNameServer(Predicate<String> predicate) {
    for (String item: nameServers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNameServer(Predicate<String> predicate) {
    for (String item: nameServers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNameServers(List<String> nameServers) {
    if (nameServers != null) {this.nameServers = new ArrayList(); for (String item : nameServers){this.addToNameServers(item);}} else { this.nameServers = null;} return (A) this;
  }
  public A withNameServers(java.lang.String... nameServers) {
    if (this.nameServers != null) {this.nameServers.clear(); _visitables.remove("nameServers"); }
    if (nameServers != null) {for (String item :nameServers){ this.addToNameServers(item);}} return (A) this;
  }
  public Boolean hasNameServers() {
    return nameServers != null && !nameServers.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSZoneStatusFluentImpl that = (DNSZoneStatusFluentImpl) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;

    if (!java.util.Objects.equals(azure, that.azure)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(gcp, that.gcp)) return false;

    if (!java.util.Objects.equals(lastSyncGeneration, that.lastSyncGeneration)) return false;

    if (!java.util.Objects.equals(lastSyncTimestamp, that.lastSyncTimestamp)) return false;

    if (!java.util.Objects.equals(nameServers, that.nameServers)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  conditions,  gcp,  lastSyncGeneration,  lastSyncTimestamp,  nameServers,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (lastSyncGeneration != null) { sb.append("lastSyncGeneration:"); sb.append(lastSyncGeneration + ","); }
    if (lastSyncTimestamp != null) { sb.append("lastSyncTimestamp:"); sb.append(lastSyncTimestamp + ","); }
    if (nameServers != null && !nameServers.isEmpty()) { sb.append("nameServers:"); sb.append(nameServers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AwsNestedImpl<N> extends AWSDNSZoneStatusFluentImpl<DNSZoneStatusFluentImpl.AwsNested<N>> implements DNSZoneStatusFluentImpl.AwsNested<N>,Nested<N>{
    AwsNestedImpl(AWSDNSZoneStatus item) {
      this.builder = new AWSDNSZoneStatusBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new AWSDNSZoneStatusBuilder(this);
    }
    AWSDNSZoneStatusBuilder builder;
    public N and() {
      return (N) DNSZoneStatusFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class AzureNestedImpl<N> extends AzureDNSZoneStatusFluentImpl<DNSZoneStatusFluentImpl.AzureNested<N>> implements DNSZoneStatusFluentImpl.AzureNested<N>,Nested<N>{
    AzureNestedImpl(AzureDNSZoneStatus item) {
      this.builder = new AzureDNSZoneStatusBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new AzureDNSZoneStatusBuilder(this);
    }
    AzureDNSZoneStatusBuilder builder;
    public N and() {
      return (N) DNSZoneStatusFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends DNSZoneConditionFluentImpl<DNSZoneStatusFluentImpl.ConditionsNested<N>> implements DNSZoneStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,DNSZoneCondition item) {
      this.index = index;
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new DNSZoneConditionBuilder(this);
    }
    DNSZoneConditionBuilder builder;
    int index;
    public N and() {
      return (N) DNSZoneStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends GCPDNSZoneStatusFluentImpl<DNSZoneStatusFluentImpl.GcpNested<N>> implements DNSZoneStatusFluentImpl.GcpNested<N>,Nested<N>{
    GcpNestedImpl(GCPDNSZoneStatus item) {
      this.builder = new GCPDNSZoneStatusBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new GCPDNSZoneStatusBuilder(this);
    }
    GCPDNSZoneStatusBuilder builder;
    public N and() {
      return (N) DNSZoneStatusFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  
}