package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolPlatformBuilder extends MachinePoolPlatformFluentImpl<MachinePoolPlatformBuilder> implements VisitableBuilder<MachinePoolPlatform,MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(false);
  }
  public MachinePoolPlatformBuilder(Boolean validationEnabled) {
    this(new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance) {
    this(fluent, instance, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withGcp(instance.getGcp());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance) {
    this(instance,false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolPlatformFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.getAws(),fluent.getAzure(),fluent.getGcp(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}