package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManageDNSAzureConfigBuilder extends ManageDNSAzureConfigFluentImpl<ManageDNSAzureConfigBuilder> implements VisitableBuilder<ManageDNSAzureConfig,ManageDNSAzureConfigBuilder>{
  public ManageDNSAzureConfigBuilder() {
    this(false);
  }
  public ManageDNSAzureConfigBuilder(Boolean validationEnabled) {
    this(new ManageDNSAzureConfig(), validationEnabled);
  }
  public ManageDNSAzureConfigBuilder(ManageDNSAzureConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ManageDNSAzureConfigBuilder(ManageDNSAzureConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManageDNSAzureConfig(), validationEnabled);
  }
  public ManageDNSAzureConfigBuilder(ManageDNSAzureConfigFluent<?> fluent,ManageDNSAzureConfig instance) {
    this(fluent, instance, false);
  }
  public ManageDNSAzureConfigBuilder(ManageDNSAzureConfigFluent<?> fluent,ManageDNSAzureConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCloudName(instance.getCloudName());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManageDNSAzureConfigBuilder(ManageDNSAzureConfig instance) {
    this(instance,false);
  }
  public ManageDNSAzureConfigBuilder(ManageDNSAzureConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCloudName(instance.getCloudName());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManageDNSAzureConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ManageDNSAzureConfig build() {
    ManageDNSAzureConfig buildable = new ManageDNSAzureConfig(fluent.getCloudName(),fluent.getCredentialsSecretRef(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}