package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReleaseImageVerificationConfigMapReferenceBuilder extends ReleaseImageVerificationConfigMapReferenceFluentImpl<ReleaseImageVerificationConfigMapReferenceBuilder> implements VisitableBuilder<ReleaseImageVerificationConfigMapReference,ReleaseImageVerificationConfigMapReferenceBuilder>{
  public ReleaseImageVerificationConfigMapReferenceBuilder() {
    this(false);
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(Boolean validationEnabled) {
    this(new ReleaseImageVerificationConfigMapReference(), validationEnabled);
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(ReleaseImageVerificationConfigMapReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(ReleaseImageVerificationConfigMapReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReleaseImageVerificationConfigMapReference(), validationEnabled);
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(ReleaseImageVerificationConfigMapReferenceFluent<?> fluent,ReleaseImageVerificationConfigMapReference instance) {
    this(fluent, instance, false);
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(ReleaseImageVerificationConfigMapReferenceFluent<?> fluent,ReleaseImageVerificationConfigMapReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(ReleaseImageVerificationConfigMapReference instance) {
    this(instance,false);
  }
  public ReleaseImageVerificationConfigMapReferenceBuilder(ReleaseImageVerificationConfigMapReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReleaseImageVerificationConfigMapReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ReleaseImageVerificationConfigMapReference build() {
    ReleaseImageVerificationConfigMapReference buildable = new ReleaseImageVerificationConfigMapReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}