package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecretMappingFluentImpl<A extends SecretMappingFluent<A>> extends BaseFluent<A> implements SecretMappingFluent<A>{
  public SecretMappingFluentImpl() {
  }
  public SecretMappingFluentImpl(SecretMapping instance) {
    if (instance != null) {
      this.withSourceRef(instance.getSourceRef());
      this.withTargetRef(instance.getTargetRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretReferenceBuilder sourceRef;
  private SecretReferenceBuilder targetRef;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildSourceRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getSourceRef() {
    return this.sourceRef!=null ?this.sourceRef.build():null;
  }
  public SecretReference buildSourceRef() {
    return this.sourceRef!=null ?this.sourceRef.build():null;
  }
  public A withSourceRef(SecretReference sourceRef) {
    _visitables.get("sourceRef").remove(this.sourceRef);
    if (sourceRef!=null){ this.sourceRef= new SecretReferenceBuilder(sourceRef); _visitables.get("sourceRef").add(this.sourceRef);} else { this.sourceRef = null; _visitables.get("sourceRef").remove(this.sourceRef); } return (A) this;
  }
  public Boolean hasSourceRef() {
    return this.sourceRef != null;
  }
  public A withNewSourceRef(String name,String namespace) {
    return (A)withSourceRef(new SecretReference(name, namespace));
  }
  public SecretMappingFluentImpl.SourceRefNested<A> withNewSourceRef() {
    return new SecretMappingFluentImpl.SourceRefNestedImpl();
  }
  public SecretMappingFluentImpl.SourceRefNested<A> withNewSourceRefLike(SecretReference item) {
    return new SecretMappingFluentImpl.SourceRefNestedImpl(item);
  }
  public SecretMappingFluentImpl.SourceRefNested<A> editSourceRef() {
    return withNewSourceRefLike(getSourceRef());
  }
  public SecretMappingFluentImpl.SourceRefNested<A> editOrNewSourceRef() {
    return withNewSourceRefLike(getSourceRef() != null ? getSourceRef(): new SecretReferenceBuilder().build());
  }
  public SecretMappingFluentImpl.SourceRefNested<A> editOrNewSourceRefLike(SecretReference item) {
    return withNewSourceRefLike(getSourceRef() != null ? getSourceRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTargetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getTargetRef() {
    return this.targetRef!=null ?this.targetRef.build():null;
  }
  public SecretReference buildTargetRef() {
    return this.targetRef!=null ?this.targetRef.build():null;
  }
  public A withTargetRef(SecretReference targetRef) {
    _visitables.get("targetRef").remove(this.targetRef);
    if (targetRef!=null){ this.targetRef= new SecretReferenceBuilder(targetRef); _visitables.get("targetRef").add(this.targetRef);} else { this.targetRef = null; _visitables.get("targetRef").remove(this.targetRef); } return (A) this;
  }
  public Boolean hasTargetRef() {
    return this.targetRef != null;
  }
  public A withNewTargetRef(String name,String namespace) {
    return (A)withTargetRef(new SecretReference(name, namespace));
  }
  public SecretMappingFluentImpl.TargetRefNested<A> withNewTargetRef() {
    return new SecretMappingFluentImpl.TargetRefNestedImpl();
  }
  public SecretMappingFluentImpl.TargetRefNested<A> withNewTargetRefLike(SecretReference item) {
    return new SecretMappingFluentImpl.TargetRefNestedImpl(item);
  }
  public SecretMappingFluentImpl.TargetRefNested<A> editTargetRef() {
    return withNewTargetRefLike(getTargetRef());
  }
  public SecretMappingFluentImpl.TargetRefNested<A> editOrNewTargetRef() {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): new SecretReferenceBuilder().build());
  }
  public SecretMappingFluentImpl.TargetRefNested<A> editOrNewTargetRefLike(SecretReference item) {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretMappingFluentImpl that = (SecretMappingFluentImpl) o;
    if (!java.util.Objects.equals(sourceRef, that.sourceRef)) return false;

    if (!java.util.Objects.equals(targetRef, that.targetRef)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(sourceRef,  targetRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sourceRef != null) { sb.append("sourceRef:"); sb.append(sourceRef + ","); }
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SourceRefNestedImpl<N> extends SecretReferenceFluentImpl<SecretMappingFluentImpl.SourceRefNested<N>> implements SecretMappingFluentImpl.SourceRefNested<N>,Nested<N>{
    SourceRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SourceRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) SecretMappingFluentImpl.this.withSourceRef(builder.build());
    }
    public N endSourceRef() {
      return and();
    }
    
  }
  class TargetRefNestedImpl<N> extends SecretReferenceFluentImpl<SecretMappingFluentImpl.TargetRefNested<N>> implements SecretMappingFluentImpl.TargetRefNested<N>,Nested<N>{
    TargetRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    TargetRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) SecretMappingFluentImpl.this.withTargetRef(builder.build());
    }
    public N endTargetRef() {
      return and();
    }
    
  }
  
}