package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SyncIdentityProviderFluentImpl<A extends SyncIdentityProviderFluent<A>> extends BaseFluent<A> implements SyncIdentityProviderFluent<A>{
  public SyncIdentityProviderFluentImpl() {
  }
  public SyncIdentityProviderFluentImpl(SyncIdentityProvider instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private SyncIdentityProviderSpecBuilder spec;
  private IdentityProviderStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public SyncIdentityProviderFluentImpl.MetadataNested<A> withNewMetadata() {
    return new SyncIdentityProviderFluentImpl.MetadataNestedImpl();
  }
  public SyncIdentityProviderFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new SyncIdentityProviderFluentImpl.MetadataNestedImpl(item);
  }
  public SyncIdentityProviderFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public SyncIdentityProviderFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public SyncIdentityProviderFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public SyncIdentityProviderSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public SyncIdentityProviderSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(SyncIdentityProviderSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new SyncIdentityProviderSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public SyncIdentityProviderFluentImpl.SpecNested<A> withNewSpec() {
    return new SyncIdentityProviderFluentImpl.SpecNestedImpl();
  }
  public SyncIdentityProviderFluentImpl.SpecNested<A> withNewSpecLike(SyncIdentityProviderSpec item) {
    return new SyncIdentityProviderFluentImpl.SpecNestedImpl(item);
  }
  public SyncIdentityProviderFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public SyncIdentityProviderFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new SyncIdentityProviderSpecBuilder().build());
  }
  public SyncIdentityProviderFluentImpl.SpecNested<A> editOrNewSpecLike(SyncIdentityProviderSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public IdentityProviderStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public IdentityProviderStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(IdentityProviderStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new IdentityProviderStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public SyncIdentityProviderFluentImpl.StatusNested<A> withNewStatus() {
    return new SyncIdentityProviderFluentImpl.StatusNestedImpl();
  }
  public SyncIdentityProviderFluentImpl.StatusNested<A> withNewStatusLike(IdentityProviderStatus item) {
    return new SyncIdentityProviderFluentImpl.StatusNestedImpl(item);
  }
  public SyncIdentityProviderFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public SyncIdentityProviderFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new IdentityProviderStatusBuilder().build());
  }
  public SyncIdentityProviderFluentImpl.StatusNested<A> editOrNewStatusLike(IdentityProviderStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SyncIdentityProviderFluentImpl that = (SyncIdentityProviderFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<SyncIdentityProviderFluentImpl.MetadataNested<N>> implements SyncIdentityProviderFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) SyncIdentityProviderFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends SyncIdentityProviderSpecFluentImpl<SyncIdentityProviderFluentImpl.SpecNested<N>> implements SyncIdentityProviderFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(SyncIdentityProviderSpec item) {
      this.builder = new SyncIdentityProviderSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new SyncIdentityProviderSpecBuilder(this);
    }
    SyncIdentityProviderSpecBuilder builder;
    public N and() {
      return (N) SyncIdentityProviderFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends IdentityProviderStatusFluentImpl<SyncIdentityProviderFluentImpl.StatusNested<N>> implements SyncIdentityProviderFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(IdentityProviderStatus item) {
      this.builder = new IdentityProviderStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new IdentityProviderStatusBuilder(this);
    }
    IdentityProviderStatusBuilder builder;
    public N and() {
      return (N) SyncIdentityProviderFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}