package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncSetListBuilder extends SyncSetListFluentImpl<SyncSetListBuilder> implements VisitableBuilder<SyncSetList,SyncSetListBuilder>{
  public SyncSetListBuilder() {
    this(false);
  }
  public SyncSetListBuilder(Boolean validationEnabled) {
    this(new SyncSetList(), validationEnabled);
  }
  public SyncSetListBuilder(SyncSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncSetListBuilder(SyncSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncSetList(), validationEnabled);
  }
  public SyncSetListBuilder(SyncSetListFluent<?> fluent,SyncSetList instance) {
    this(fluent, instance, false);
  }
  public SyncSetListBuilder(SyncSetListFluent<?> fluent,SyncSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncSetListBuilder(SyncSetList instance) {
    this(instance,false);
  }
  public SyncSetListBuilder(SyncSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncSetListFluent<?> fluent;
  Boolean validationEnabled;
  public SyncSetList build() {
    SyncSetList buildable = new SyncSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}