package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncSetSpecBuilder extends SyncSetSpecFluentImpl<SyncSetSpecBuilder> implements VisitableBuilder<SyncSetSpec,SyncSetSpecBuilder>{
  public SyncSetSpecBuilder() {
    this(false);
  }
  public SyncSetSpecBuilder(Boolean validationEnabled) {
    this(new SyncSetSpec(), validationEnabled);
  }
  public SyncSetSpecBuilder(SyncSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncSetSpecBuilder(SyncSetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncSetSpec(), validationEnabled);
  }
  public SyncSetSpecBuilder(SyncSetSpecFluent<?> fluent,SyncSetSpec instance) {
    this(fluent, instance, false);
  }
  public SyncSetSpecBuilder(SyncSetSpecFluent<?> fluent,SyncSetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApplyBehavior(instance.getApplyBehavior());
      fluent.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
      fluent.withPatches(instance.getPatches());
      fluent.withResourceApplyMode(instance.getResourceApplyMode());
      fluent.withResources(instance.getResources());
      fluent.withSecretMappings(instance.getSecretMappings());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncSetSpecBuilder(SyncSetSpec instance) {
    this(instance,false);
  }
  public SyncSetSpecBuilder(SyncSetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApplyBehavior(instance.getApplyBehavior());
      this.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
      this.withPatches(instance.getPatches());
      this.withResourceApplyMode(instance.getResourceApplyMode());
      this.withResources(instance.getResources());
      this.withSecretMappings(instance.getSecretMappings());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncSetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SyncSetSpec build() {
    SyncSetSpec buildable = new SyncSetSpec(fluent.getApplyBehavior(),fluent.getClusterDeploymentRefs(),fluent.getPatches(),fluent.getResourceApplyMode(),fluent.getResources(),fluent.getSecretMappings());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}