package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterDeploymentCustomizationSpecFluent<A extends ClusterDeploymentCustomizationSpecFluent<A>> extends BaseFluent<A>{
  public ClusterDeploymentCustomizationSpecFluent() {
  }
  
  public ClusterDeploymentCustomizationSpecFluent(ClusterDeploymentCustomizationSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PatchEntityBuilder> installConfigPatches = new ArrayList<PatchEntityBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterDeploymentCustomizationSpec instance) {
    instance = (instance != null ? instance : new ClusterDeploymentCustomizationSpec());
    if (instance != null) {
          this.withInstallConfigPatches(instance.getInstallConfigPatches());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToInstallConfigPatches(int index,PatchEntity item) {
    if (this.installConfigPatches == null) {this.installConfigPatches = new ArrayList<PatchEntityBuilder>();}
    PatchEntityBuilder builder = new PatchEntityBuilder(item);
    if (index < 0 || index >= installConfigPatches.size()) { _visitables.get("installConfigPatches").add(builder); installConfigPatches.add(builder); } else { _visitables.get("installConfigPatches").add(index, builder); installConfigPatches.add(index, builder);}
    return (A)this;
  }
  
  public A setToInstallConfigPatches(int index,PatchEntity item) {
    if (this.installConfigPatches == null) {this.installConfigPatches = new ArrayList<PatchEntityBuilder>();}
    PatchEntityBuilder builder = new PatchEntityBuilder(item);
    if (index < 0 || index >= installConfigPatches.size()) { _visitables.get("installConfigPatches").add(builder); installConfigPatches.add(builder); } else { _visitables.get("installConfigPatches").set(index, builder); installConfigPatches.set(index, builder);}
    return (A)this;
  }
  
  public A addToInstallConfigPatches(io.fabric8.openshift.api.model.hive.v1.PatchEntity... items) {
    if (this.installConfigPatches == null) {this.installConfigPatches = new ArrayList<PatchEntityBuilder>();}
    for (PatchEntity item : items) {PatchEntityBuilder builder = new PatchEntityBuilder(item);_visitables.get("installConfigPatches").add(builder);this.installConfigPatches.add(builder);} return (A)this;
  }
  
  public A addAllToInstallConfigPatches(Collection<PatchEntity> items) {
    if (this.installConfigPatches == null) {this.installConfigPatches = new ArrayList<PatchEntityBuilder>();}
    for (PatchEntity item : items) {PatchEntityBuilder builder = new PatchEntityBuilder(item);_visitables.get("installConfigPatches").add(builder);this.installConfigPatches.add(builder);} return (A)this;
  }
  
  public A removeFromInstallConfigPatches(io.fabric8.openshift.api.model.hive.v1.PatchEntity... items) {
    if (this.installConfigPatches == null) return (A)this;
    for (PatchEntity item : items) {PatchEntityBuilder builder = new PatchEntityBuilder(item);_visitables.get("installConfigPatches").remove(builder); this.installConfigPatches.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInstallConfigPatches(Collection<PatchEntity> items) {
    if (this.installConfigPatches == null) return (A)this;
    for (PatchEntity item : items) {PatchEntityBuilder builder = new PatchEntityBuilder(item);_visitables.get("installConfigPatches").remove(builder); this.installConfigPatches.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInstallConfigPatches(Predicate<PatchEntityBuilder> predicate) {
    if (installConfigPatches == null) return (A) this;
    final Iterator<PatchEntityBuilder> each = installConfigPatches.iterator();
    final List visitables = _visitables.get("installConfigPatches");
    while (each.hasNext()) {
      PatchEntityBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PatchEntity> buildInstallConfigPatches() {
    return this.installConfigPatches != null ? build(installConfigPatches) : null;
  }
  
  public PatchEntity buildInstallConfigPatch(int index) {
    return this.installConfigPatches.get(index).build();
  }
  
  public PatchEntity buildFirstInstallConfigPatch() {
    return this.installConfigPatches.get(0).build();
  }
  
  public PatchEntity buildLastInstallConfigPatch() {
    return this.installConfigPatches.get(installConfigPatches.size() - 1).build();
  }
  
  public PatchEntity buildMatchingInstallConfigPatch(Predicate<PatchEntityBuilder> predicate) {
      for (PatchEntityBuilder item : installConfigPatches) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInstallConfigPatch(Predicate<PatchEntityBuilder> predicate) {
      for (PatchEntityBuilder item : installConfigPatches) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInstallConfigPatches(List<PatchEntity> installConfigPatches) {
    if (this.installConfigPatches != null) {
      this._visitables.get("installConfigPatches").clear();
    }
    if (installConfigPatches != null) {
        this.installConfigPatches = new ArrayList();
        for (PatchEntity item : installConfigPatches) {
          this.addToInstallConfigPatches(item);
        }
    } else {
      this.installConfigPatches = null;
    }
    return (A) this;
  }
  
  public A withInstallConfigPatches(io.fabric8.openshift.api.model.hive.v1.PatchEntity... installConfigPatches) {
    if (this.installConfigPatches != null) {
        this.installConfigPatches.clear();
        _visitables.remove("installConfigPatches");
    }
    if (installConfigPatches != null) {
      for (PatchEntity item : installConfigPatches) {
        this.addToInstallConfigPatches(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasInstallConfigPatches() {
    return this.installConfigPatches != null && !this.installConfigPatches.isEmpty();
  }
  
  public A addNewInstallConfigPatch(String from,String op,String path,String value) {
    return (A)addToInstallConfigPatches(new PatchEntity(from, op, path, value));
  }
  
  public InstallConfigPatchesNested<A> addNewInstallConfigPatch() {
    return new InstallConfigPatchesNested(-1, null);
  }
  
  public InstallConfigPatchesNested<A> addNewInstallConfigPatchLike(PatchEntity item) {
    return new InstallConfigPatchesNested(-1, item);
  }
  
  public InstallConfigPatchesNested<A> setNewInstallConfigPatchLike(int index,PatchEntity item) {
    return new InstallConfigPatchesNested(index, item);
  }
  
  public InstallConfigPatchesNested<A> editInstallConfigPatch(int index) {
    if (installConfigPatches.size() <= index) throw new RuntimeException("Can't edit installConfigPatches. Index exceeds size.");
    return setNewInstallConfigPatchLike(index, buildInstallConfigPatch(index));
  }
  
  public InstallConfigPatchesNested<A> editFirstInstallConfigPatch() {
    if (installConfigPatches.size() == 0) throw new RuntimeException("Can't edit first installConfigPatches. The list is empty.");
    return setNewInstallConfigPatchLike(0, buildInstallConfigPatch(0));
  }
  
  public InstallConfigPatchesNested<A> editLastInstallConfigPatch() {
    int index = installConfigPatches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last installConfigPatches. The list is empty.");
    return setNewInstallConfigPatchLike(index, buildInstallConfigPatch(index));
  }
  
  public InstallConfigPatchesNested<A> editMatchingInstallConfigPatch(Predicate<PatchEntityBuilder> predicate) {
    int index = -1;
    for (int i=0;i<installConfigPatches.size();i++) { 
    if (predicate.test(installConfigPatches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching installConfigPatches. No match found.");
    return setNewInstallConfigPatchLike(index, buildInstallConfigPatch(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterDeploymentCustomizationSpecFluent that = (ClusterDeploymentCustomizationSpecFluent) o;
    if (!java.util.Objects.equals(installConfigPatches, that.installConfigPatches)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(installConfigPatches,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (installConfigPatches != null && !installConfigPatches.isEmpty()) { sb.append("installConfigPatches:"); sb.append(installConfigPatches + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InstallConfigPatchesNested<N> extends PatchEntityFluent<InstallConfigPatchesNested<N>> implements Nested<N>{
    InstallConfigPatchesNested(int index,PatchEntity item) {
      this.index = index;
      this.builder = new PatchEntityBuilder(this, item);
    }
    PatchEntityBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterDeploymentCustomizationSpecFluent.this.setToInstallConfigPatches(index,builder.build());
    }
    
    public N endInstallConfigPatch() {
      return and();
    }
    
  
  }

}