package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.openshift.api.model.customresourcestatus.conditions.v1.Condition;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterDeploymentCustomizationStatusFluent<A extends ClusterDeploymentCustomizationStatusFluent<A>> extends BaseFluent<A>{
  public ClusterDeploymentCustomizationStatusFluent() {
  }
  
  public ClusterDeploymentCustomizationStatusFluent(ClusterDeploymentCustomizationStatus instance) {
    this.copyInstance(instance);
  }
  private LocalObjectReferenceBuilder clusterDeploymentRef;
  private LocalObjectReferenceBuilder clusterPoolRef;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String lastAppliedConfiguration;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterDeploymentCustomizationStatus instance) {
    instance = (instance != null ? instance : new ClusterDeploymentCustomizationStatus());
    if (instance != null) {
          this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
          this.withClusterPoolRef(instance.getClusterPoolRef());
          this.withConditions(instance.getConditions());
          this.withLastAppliedConfiguration(instance.getLastAppliedConfiguration());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LocalObjectReference buildClusterDeploymentRef() {
    return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
  }
  
  public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
    this._visitables.remove("clusterDeploymentRef");
    if (clusterDeploymentRef != null) {
        this.clusterDeploymentRef = new LocalObjectReferenceBuilder(clusterDeploymentRef);
        this._visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);
    } else {
        this.clusterDeploymentRef = null;
        this._visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterDeploymentRef() {
    return this.clusterDeploymentRef != null;
  }
  
  public A withNewClusterDeploymentRef(String name) {
    return (A)withClusterDeploymentRef(new LocalObjectReference(name));
  }
  
  public ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
    return new ClusterDeploymentRefNested(null);
  }
  
  public ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new ClusterDeploymentRefNested(item);
  }
  
  public ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(null));
  }
  
  public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
    return withNewClusterDeploymentRefLike(java.util.Optional.ofNullable(buildClusterDeploymentRef()).orElse(item));
  }
  
  public LocalObjectReference buildClusterPoolRef() {
    return this.clusterPoolRef != null ? this.clusterPoolRef.build() : null;
  }
  
  public A withClusterPoolRef(LocalObjectReference clusterPoolRef) {
    this._visitables.remove("clusterPoolRef");
    if (clusterPoolRef != null) {
        this.clusterPoolRef = new LocalObjectReferenceBuilder(clusterPoolRef);
        this._visitables.get("clusterPoolRef").add(this.clusterPoolRef);
    } else {
        this.clusterPoolRef = null;
        this._visitables.get("clusterPoolRef").remove(this.clusterPoolRef);
    }
    return (A) this;
  }
  
  public boolean hasClusterPoolRef() {
    return this.clusterPoolRef != null;
  }
  
  public A withNewClusterPoolRef(String name) {
    return (A)withClusterPoolRef(new LocalObjectReference(name));
  }
  
  public ClusterPoolRefNested<A> withNewClusterPoolRef() {
    return new ClusterPoolRefNested(null);
  }
  
  public ClusterPoolRefNested<A> withNewClusterPoolRefLike(LocalObjectReference item) {
    return new ClusterPoolRefNested(item);
  }
  
  public ClusterPoolRefNested<A> editClusterPoolRef() {
    return withNewClusterPoolRefLike(java.util.Optional.ofNullable(buildClusterPoolRef()).orElse(null));
  }
  
  public ClusterPoolRefNested<A> editOrNewClusterPoolRef() {
    return withNewClusterPoolRefLike(java.util.Optional.ofNullable(buildClusterPoolRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ClusterPoolRefNested<A> editOrNewClusterPoolRefLike(LocalObjectReference item) {
    return withNewClusterPoolRefLike(java.util.Optional.ofNullable(buildClusterPoolRef()).orElse(item));
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.customresourcestatus.conditions.v1.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.customresourcestatus.conditions.v1.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.customresourcestatus.conditions.v1.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getLastAppliedConfiguration() {
    return this.lastAppliedConfiguration;
  }
  
  public A withLastAppliedConfiguration(String lastAppliedConfiguration) {
    this.lastAppliedConfiguration = lastAppliedConfiguration;
    return (A) this;
  }
  
  public boolean hasLastAppliedConfiguration() {
    return this.lastAppliedConfiguration != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterDeploymentCustomizationStatusFluent that = (ClusterDeploymentCustomizationStatusFluent) o;
    if (!java.util.Objects.equals(clusterDeploymentRef, that.clusterDeploymentRef)) return false;
    if (!java.util.Objects.equals(clusterPoolRef, that.clusterPoolRef)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(lastAppliedConfiguration, that.lastAppliedConfiguration)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterDeploymentRef,  clusterPoolRef,  conditions,  lastAppliedConfiguration,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterDeploymentRef != null) { sb.append("clusterDeploymentRef:"); sb.append(clusterDeploymentRef + ","); }
    if (clusterPoolRef != null) { sb.append("clusterPoolRef:"); sb.append(clusterPoolRef + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastAppliedConfiguration != null) { sb.append("lastAppliedConfiguration:"); sb.append(lastAppliedConfiguration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterDeploymentRefNested<N> extends LocalObjectReferenceFluent<ClusterDeploymentRefNested<N>> implements Nested<N>{
    ClusterDeploymentRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterDeploymentCustomizationStatusFluent.this.withClusterDeploymentRef(builder.build());
    }
    
    public N endClusterDeploymentRef() {
      return and();
    }
    
  
  }
  public class ClusterPoolRefNested<N> extends LocalObjectReferenceFluent<ClusterPoolRefNested<N>> implements Nested<N>{
    ClusterPoolRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterDeploymentCustomizationStatusFluent.this.withClusterPoolRef(builder.build());
    }
    
    public N endClusterPoolRef() {
      return and();
    }
    
  
  }

}