package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterDeprovisionSpecFluent<A extends ClusterDeprovisionSpecFluent<A>> extends BaseFluent<A>{
  public ClusterDeprovisionSpecFluent() {
  }
  
  public ClusterDeprovisionSpecFluent(ClusterDeprovisionSpec instance) {
    this.copyInstance(instance);
  }
  private String baseDomain;
  private String clusterID;
  private String clusterName;
  private String infraID;
  private ClusterDeprovisionPlatformBuilder platform;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterDeprovisionSpec instance) {
    instance = (instance != null ? instance : new ClusterDeprovisionSpec());
    if (instance != null) {
          this.withBaseDomain(instance.getBaseDomain());
          this.withClusterID(instance.getClusterID());
          this.withClusterName(instance.getClusterName());
          this.withInfraID(instance.getInfraID());
          this.withPlatform(instance.getPlatform());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBaseDomain() {
    return this.baseDomain;
  }
  
  public A withBaseDomain(String baseDomain) {
    this.baseDomain = baseDomain;
    return (A) this;
  }
  
  public boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  public String getClusterID() {
    return this.clusterID;
  }
  
  public A withClusterID(String clusterID) {
    this.clusterID = clusterID;
    return (A) this;
  }
  
  public boolean hasClusterID() {
    return this.clusterID != null;
  }
  
  public String getClusterName() {
    return this.clusterName;
  }
  
  public A withClusterName(String clusterName) {
    this.clusterName = clusterName;
    return (A) this;
  }
  
  public boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  public String getInfraID() {
    return this.infraID;
  }
  
  public A withInfraID(String infraID) {
    this.infraID = infraID;
    return (A) this;
  }
  
  public boolean hasInfraID() {
    return this.infraID != null;
  }
  
  public ClusterDeprovisionPlatform buildPlatform() {
    return this.platform != null ? this.platform.build() : null;
  }
  
  public A withPlatform(ClusterDeprovisionPlatform platform) {
    this._visitables.remove("platform");
    if (platform != null) {
        this.platform = new ClusterDeprovisionPlatformBuilder(platform);
        this._visitables.get("platform").add(this.platform);
    } else {
        this.platform = null;
        this._visitables.get("platform").remove(this.platform);
    }
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(ClusterDeprovisionPlatform item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new ClusterDeprovisionPlatformBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(ClusterDeprovisionPlatform item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterDeprovisionSpecFluent that = (ClusterDeprovisionSpecFluent) o;
    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;
    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;
    if (!java.util.Objects.equals(infraID, that.infraID)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(baseDomain,  clusterID,  clusterName,  infraID,  platform,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (infraID != null) { sb.append("infraID:"); sb.append(infraID + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PlatformNested<N> extends ClusterDeprovisionPlatformFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(ClusterDeprovisionPlatform item) {
      this.builder = new ClusterDeprovisionPlatformBuilder(this, item);
    }
    ClusterDeprovisionPlatformBuilder builder;
    
    public N and() {
      return (N) ClusterDeprovisionSpecFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }

}