package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.openshift.api.model.hive.aws.v1.PlatformStatus;
import io.fabric8.openshift.api.model.hive.aws.v1.PlatformStatusBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformStatusFluent<A extends io.fabric8.openshift.api.model.hive.v1.PlatformStatusFluent<A>> extends BaseFluent<A>{
  public PlatformStatusFluent() {
  }
  
  public PlatformStatusFluent(io.fabric8.openshift.api.model.hive.v1.PlatformStatus instance) {
    this.copyInstance(instance);
  }
  private PlatformStatusBuilder aws;
  private io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatusBuilder gcp;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(io.fabric8.openshift.api.model.hive.v1.PlatformStatus instance) {
    instance = (instance != null ? instance : new io.fabric8.openshift.api.model.hive.v1.PlatformStatus());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withGcp(instance.getGcp());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PlatformStatus buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(PlatformStatus aws) {
    this._visitables.remove("aws");
    if (aws != null) {
        this.aws = new PlatformStatusBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(PlatformStatus item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new PlatformStatusBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(PlatformStatus item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatus buildGcp() {
    return this.gcp != null ? this.gcp.build() : null;
  }
  
  public A withGcp(io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatus gcp) {
    this._visitables.remove("gcp");
    if (gcp != null) {
        this.gcp = new io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatusBuilder(gcp);
        this._visitables.get("gcp").add(this.gcp);
    } else {
        this.gcp = null;
        this._visitables.get("gcp").remove(this.gcp);
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatus item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatusBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatus item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformStatusFluent that = (PlatformStatusFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  gcp,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends io.fabric8.openshift.api.model.hive.aws.v1.PlatformStatusFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(PlatformStatus item) {
      this.builder = new PlatformStatusBuilder(this, item);
    }
    PlatformStatusBuilder builder;
    
    public N and() {
      return (N) PlatformStatusFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatusFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatus item) {
      this.builder = new io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatusBuilder(this, item);
    }
    io.fabric8.openshift.api.model.hive.gcp.v1.PlatformStatusBuilder builder;
    
    public N and() {
      return (N) PlatformStatusFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }

}