package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private String networkProjectID;
  private String onHostMaintenance;
  private OSDiskBuilder osDisk;
  private String secureBoot;
  private String serviceAccount;
  private String type;
  private ArrayList<UserTagBuilder> userTags = new ArrayList<UserTagBuilder>();
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withNetworkProjectID(instance.getNetworkProjectID());
          this.withOnHostMaintenance(instance.getOnHostMaintenance());
          this.withOsDisk(instance.getOsDisk());
          this.withSecureBoot(instance.getSecureBoot());
          this.withServiceAccount(instance.getServiceAccount());
          this.withType(instance.getType());
          this.withUserTags(instance.getUserTags());
          this.withZones(instance.getZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getNetworkProjectID() {
    return this.networkProjectID;
  }
  
  public A withNetworkProjectID(String networkProjectID) {
    this.networkProjectID = networkProjectID;
    return (A) this;
  }
  
  public boolean hasNetworkProjectID() {
    return this.networkProjectID != null;
  }
  
  public String getOnHostMaintenance() {
    return this.onHostMaintenance;
  }
  
  public A withOnHostMaintenance(String onHostMaintenance) {
    this.onHostMaintenance = onHostMaintenance;
    return (A) this;
  }
  
  public boolean hasOnHostMaintenance() {
    return this.onHostMaintenance != null;
  }
  
  public OSDisk buildOsDisk() {
    return this.osDisk != null ? this.osDisk.build() : null;
  }
  
  public A withOsDisk(OSDisk osDisk) {
    this._visitables.remove("osDisk");
    if (osDisk != null) {
        this.osDisk = new OSDiskBuilder(osDisk);
        this._visitables.get("osDisk").add(this.osDisk);
    } else {
        this.osDisk = null;
        this._visitables.get("osDisk").remove(this.osDisk);
    }
    return (A) this;
  }
  
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  
  public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new OsDiskNested(item);
  }
  
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new OSDiskBuilder().build()));
  }
  
  public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  
  public String getSecureBoot() {
    return this.secureBoot;
  }
  
  public A withSecureBoot(String secureBoot) {
    this.secureBoot = secureBoot;
    return (A) this;
  }
  
  public boolean hasSecureBoot() {
    return this.secureBoot != null;
  }
  
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount = serviceAccount;
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToUserTags(int index,UserTag item) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    UserTagBuilder builder = new UserTagBuilder(item);
    if (index < 0 || index >= userTags.size()) {
        _visitables.get("userTags").add(builder);
        userTags.add(builder);
    } else {
        _visitables.get("userTags").add(builder);
        userTags.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToUserTags(int index,UserTag item) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    UserTagBuilder builder = new UserTagBuilder(item);
    if (index < 0 || index >= userTags.size()) {
        _visitables.get("userTags").add(builder);
        userTags.add(builder);
    } else {
        _visitables.get("userTags").add(builder);
        userTags.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToUserTags(io.fabric8.openshift.api.model.hive.gcp.v1.UserTag... items) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").add(builder);this.userTags.add(builder);} return (A)this;
  }
  
  public A addAllToUserTags(Collection<UserTag> items) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").add(builder);this.userTags.add(builder);} return (A)this;
  }
  
  public A removeFromUserTags(io.fabric8.openshift.api.model.hive.gcp.v1.UserTag... items) {
    if (this.userTags == null) return (A)this;
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").remove(builder); this.userTags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromUserTags(Collection<UserTag> items) {
    if (this.userTags == null) return (A)this;
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").remove(builder); this.userTags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromUserTags(Predicate<UserTagBuilder> predicate) {
    if (userTags == null) return (A) this;
    final Iterator<UserTagBuilder> each = userTags.iterator();
    final List visitables = _visitables.get("userTags");
    while (each.hasNext()) {
      UserTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<UserTag> buildUserTags() {
    return this.userTags != null ? build(userTags) : null;
  }
  
  public UserTag buildUserTag(int index) {
    return this.userTags.get(index).build();
  }
  
  public UserTag buildFirstUserTag() {
    return this.userTags.get(0).build();
  }
  
  public UserTag buildLastUserTag() {
    return this.userTags.get(userTags.size() - 1).build();
  }
  
  public UserTag buildMatchingUserTag(Predicate<UserTagBuilder> predicate) {
      for (UserTagBuilder item : userTags) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingUserTag(Predicate<UserTagBuilder> predicate) {
      for (UserTagBuilder item : userTags) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUserTags(List<UserTag> userTags) {
    if (this.userTags != null) {
      this._visitables.get("userTags").clear();
    }
    if (userTags != null) {
        this.userTags = new ArrayList();
        for (UserTag item : userTags) {
          this.addToUserTags(item);
        }
    } else {
      this.userTags = null;
    }
    return (A) this;
  }
  
  public A withUserTags(io.fabric8.openshift.api.model.hive.gcp.v1.UserTag... userTags) {
    if (this.userTags != null) {
        this.userTags.clear();
        _visitables.remove("userTags");
    }
    if (userTags != null) {
      for (UserTag item : userTags) {
        this.addToUserTags(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUserTags() {
    return this.userTags != null && !this.userTags.isEmpty();
  }
  
  public A addNewUserTag(String key,String parentID,String value) {
    return (A)addToUserTags(new UserTag(key, parentID, value));
  }
  
  public UserTagsNested<A> addNewUserTag() {
    return new UserTagsNested(-1, null);
  }
  
  public UserTagsNested<A> addNewUserTagLike(UserTag item) {
    return new UserTagsNested(-1, item);
  }
  
  public UserTagsNested<A> setNewUserTagLike(int index,UserTag item) {
    return new UserTagsNested(index, item);
  }
  
  public UserTagsNested<A> editUserTag(int index) {
    if (userTags.size() <= index) throw new RuntimeException("Can't edit userTags. Index exceeds size.");
    return setNewUserTagLike(index, buildUserTag(index));
  }
  
  public UserTagsNested<A> editFirstUserTag() {
    if (userTags.size() == 0) throw new RuntimeException("Can't edit first userTags. The list is empty.");
    return setNewUserTagLike(0, buildUserTag(0));
  }
  
  public UserTagsNested<A> editLastUserTag() {
    int index = userTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last userTags. The list is empty.");
    return setNewUserTagLike(index, buildUserTag(index));
  }
  
  public UserTagsNested<A> editMatchingUserTag(Predicate<UserTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<userTags.size();i++) { 
    if (predicate.test(userTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching userTags. No match found.");
    return setNewUserTagLike(index, buildUserTag(index));
  }
  
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public List<String> getZones() {
    return this.zones;
  }
  
  public String getZone(int index) {
    return this.zones.get(index);
  }
  
  public String getFirstZone() {
    return this.zones.get(0);
  }
  
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  
  public String getMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withZones(List<String> zones) {
    if (zones != null) {
        this.zones = new ArrayList();
        for (String item : zones) {
          this.addToZones(item);
        }
    } else {
      this.zones = null;
    }
    return (A) this;
  }
  
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {
        this.zones.clear();
        _visitables.remove("zones");
    }
    if (zones != null) {
      for (String item : zones) {
        this.addToZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasZones() {
    return this.zones != null && !this.zones.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(networkProjectID, that.networkProjectID)) return false;
    if (!java.util.Objects.equals(onHostMaintenance, that.onHostMaintenance)) return false;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;
    if (!java.util.Objects.equals(secureBoot, that.secureBoot)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(userTags, that.userTags)) return false;
    if (!java.util.Objects.equals(zones, that.zones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(networkProjectID,  onHostMaintenance,  osDisk,  secureBoot,  serviceAccount,  type,  userTags,  zones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (networkProjectID != null) { sb.append("networkProjectID:"); sb.append(networkProjectID + ","); }
    if (onHostMaintenance != null) { sb.append("onHostMaintenance:"); sb.append(onHostMaintenance + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (secureBoot != null) { sb.append("secureBoot:"); sb.append(secureBoot + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (userTags != null && !userTags.isEmpty()) { sb.append("userTags:"); sb.append(userTags + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OsDiskNested<N> extends OSDiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OSDiskBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withOsDisk(builder.build());
    }
    
    public N endOsDisk() {
      return and();
    }
    
  
  }
  public class UserTagsNested<N> extends UserTagFluent<UserTagsNested<N>> implements Nested<N>{
    UserTagsNested(int index,UserTag item) {
      this.index = index;
      this.builder = new UserTagBuilder(this, item);
    }
    UserTagBuilder builder;
    int index;
    
    public N and() {
      return (N) MachinePoolFluent.this.setToUserTags(index,builder.build());
    }
    
    public N endUserTag() {
      return and();
    }
    
  
  }

}